/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.queries;

import de.jaggl.sqlbuilder.columns.Column;
import de.jaggl.sqlbuilder.columns.number.NumberColumn;
import de.jaggl.sqlbuilder.columns.string.StringColumn;
import de.jaggl.sqlbuilder.conditions.CombinedCondition;
import de.jaggl.sqlbuilder.conditions.Condition;
import de.jaggl.sqlbuilder.dialect.Dialect;
import de.jaggl.sqlbuilder.domain.ConditionType;
import de.jaggl.sqlbuilder.domain.PlainValuable;
import de.jaggl.sqlbuilder.domain.Valuable;
import de.jaggl.sqlbuilder.domain.ValuableColumn;
import de.jaggl.sqlbuilder.domain.ValuableFunction;
import de.jaggl.sqlbuilder.functions.Function;
import de.jaggl.sqlbuilder.queries.Query;
import de.jaggl.sqlbuilder.schema.Table;
import de.jaggl.sqlbuilder.utils.Indentation;
import java.util.LinkedHashMap;
import java.util.Map;

public class Update
implements Query {
    private final Table table;
    private Map<Column, Valuable> values = new LinkedHashMap<Column, Valuable>();
    private Condition where;
    private ConditionType whereConditionType;

    Update(Update update) {
        this.table = update.table;
        this.values = update.values != null ? new LinkedHashMap<Column, Valuable>(update.values) : null;
        this.where = CombinedCondition.getCopy(update.where);
        this.whereConditionType = update.whereConditionType;
    }

    public Update set(StringColumn<?> column, CharSequence value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Update set(NumberColumn<?, ?> column, Number value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Update set(NumberColumn<?, ?> column, long value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Update set(NumberColumn<?, ?> column, double value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Update set(Column column, Function function) {
        return this.addValue(column, new ValuableFunction(function));
    }

    public Update set(Column column, Column otherColumn) {
        return this.addValue(column, new ValuableColumn(otherColumn));
    }

    private Update addValue(Column column, Valuable value) {
        this.values.put(column, value);
        return this;
    }

    public Update where(Condition condition) {
        this.where = condition;
        this.whereConditionType = ConditionType.WHERE;
        return this;
    }

    public Update whereNot(Condition condition) {
        this.where = condition;
        this.whereConditionType = ConditionType.WHERE_NOT;
        return this;
    }

    @Override
    public String build(Dialect dialect, Indentation indentation) {
        return dialect.build(this, indentation);
    }

    public static void clearWheres(Update update) {
        update.where = null;
    }

    public static Update copy(Update update) {
        return new Update(update);
    }

    Update(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public Map<Column, Valuable> getValues() {
        return this.values;
    }

    public Condition getWhere() {
        return this.where;
    }

    public ConditionType getWhereConditionType() {
        return this.whereConditionType;
    }

    public String toString() {
        return "Update(table=" + this.getTable() + ", values=" + this.getValues() + ", where=" + this.getWhere() + ", whereConditionType=" + this.getWhereConditionType() + ")";
    }
}

