/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.queries;

import de.jaggl.sqlbuilder.columns.Column;
import de.jaggl.sqlbuilder.columns.number.NumberColumn;
import de.jaggl.sqlbuilder.columns.string.StringColumn;
import de.jaggl.sqlbuilder.dialect.Dialect;
import de.jaggl.sqlbuilder.domain.PlainValuable;
import de.jaggl.sqlbuilder.domain.Valuable;
import de.jaggl.sqlbuilder.domain.ValuableColumn;
import de.jaggl.sqlbuilder.domain.ValuableFunction;
import de.jaggl.sqlbuilder.functions.Function;
import de.jaggl.sqlbuilder.queries.Query;
import de.jaggl.sqlbuilder.schema.Table;
import de.jaggl.sqlbuilder.utils.Indentation;
import java.util.LinkedHashMap;
import java.util.Map;

public class Insert
implements Query {
    private Table table;
    private Map<Column, Valuable> values = new LinkedHashMap<Column, Valuable>();

    Insert(Insert insert) {
        this.table = insert.table;
        this.values = insert.values != null ? new LinkedHashMap<Column, Valuable>(insert.values) : null;
    }

    public Insert into(Table insertTable) {
        this.table = insertTable;
        return this;
    }

    public Insert set(StringColumn<?> column, CharSequence value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Insert set(NumberColumn<?, ?> column, Number value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Insert set(NumberColumn<?, ?> column, long value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Insert set(NumberColumn<?, ?> column, double value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Insert set(Column column, Function function) {
        return this.addValue(column, new ValuableFunction(function));
    }

    public Insert set(Column column, Column otherColumn) {
        return this.addValue(column, new ValuableColumn(otherColumn));
    }

    private Insert addValue(Column column, Valuable value) {
        this.values.put(column, value);
        return this;
    }

    @Override
    public String build(Dialect dialect, Indentation indentation) {
        return dialect.build(this, indentation);
    }

    public static Insert copy(Insert insert) {
        return new Insert(insert);
    }

    Insert() {
    }

    public Table getTable() {
        return this.table;
    }

    public Map<Column, Valuable> getValues() {
        return this.values;
    }

    public String toString() {
        return "Insert(table=" + this.getTable() + ", values=" + this.getValues() + ")";
    }
}

