/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.functions;

import de.jaggl.sqlbuilder.columns.Column;
import de.jaggl.sqlbuilder.conditions.GenericCondition;
import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.functions.Function;
import de.jaggl.sqlbuilder.utils.Indentation;

public abstract class ColumnFunction
implements Function {
    protected final Column column;
    protected final String definition;
    private String alias;

    @Override
    public String getValue(BuildingContext context, Indentation indentation) {
        return this.definition + "(" + this.column.getFullNameOrAlias(context) + ")";
    }

    public GenericCondition isEqualTo(Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_EQUAL_TO, this, otherColumn);
    }

    public GenericCondition isNotEqualTo(Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_EQUAL_TO, this, otherColumn);
    }

    public ColumnFunction(Column column, String definition, String alias) {
        this.column = column;
        this.definition = definition;
        this.alias = alias;
    }

    public ColumnFunction(Column column, String definition) {
        this.column = column;
        this.definition = definition;
    }

    public String toString() {
        return "ColumnFunction(column=" + this.column + ", definition=" + this.definition + ", alias=" + this.getAlias() + ")";
    }

    @Override
    public String getAlias() {
        return this.alias;
    }
}

