/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.dialect;

import de.jaggl.sqlbuilder.dialect.Dialects;
import de.jaggl.sqlbuilder.dialect.Labels;
import de.jaggl.sqlbuilder.queries.Delete;
import de.jaggl.sqlbuilder.queries.Insert;
import de.jaggl.sqlbuilder.queries.Select;
import de.jaggl.sqlbuilder.queries.Update;
import de.jaggl.sqlbuilder.schema.Table;
import de.jaggl.sqlbuilder.utils.Indentation;
import java.time.format.DateTimeFormatter;

public interface Dialect {
    public String getName();

    public String build(Insert var1, Indentation var2);

    public String build(Update var1, Indentation var2);

    public String build(Delete var1, Indentation var2);

    public String build(Select var1, Indentation var2);

    public String buildCreate(Table var1, Indentation var2);

    public DateTimeFormatter getDateFormatter();

    public DateTimeFormatter getDateTimeFormatter();

    public Labels getLabels();

    public static void register(Dialect dialect) {
        Dialects.register(dialect);
    }

    public static void unregister(String name) {
        Dialects.unregister(name);
    }

    public static Dialect forName(String name) {
        return Dialects.forName(name);
    }

    public static Dialect getDefault() {
        return Dialect.forName(System.getProperty("sqlbuilder.defaultDialect", "MYSQL"));
    }
}

