/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.conditions;

import de.jaggl.sqlbuilder.conditions.Condition;
import de.jaggl.sqlbuilder.dialect.Labels;
import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.utils.BuilderUtils;
import de.jaggl.sqlbuilder.utils.Indentation;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.Function;

public class GenericCondition
extends Condition {
    private GenericConditionType type;
    private Object[] values;

    public GenericCondition(GenericConditionType type, Object ... values) {
        this.type = type;
        this.values = values;
    }

    @Override
    protected String doBuild(BuildingContext context, Indentation indentation) {
        return MessageFormat.format(this.type.getRenderingString(context), Arrays.asList(this.values).stream().map(value -> BuilderUtils.getValued(value, context, indentation)).toArray());
    }

    @Override
    public String toString() {
        return "GenericCondition(super=" + super.toString() + ", type=" + this.type + ", values=" + Arrays.deepToString(this.values) + ")";
    }

    public static enum GenericConditionType {
        IS_EQUAL_TO(Labels::getIsEqualTo),
        IS_NOT_EQUAL_TO(Labels::getIsNotEqualTo),
        IS_GREATER_THAN(Labels::getIsGreaterThan),
        IS_GREATER_THAN_OR_EQUAL_TO(Labels::getIsGreaterThanOrEqualTo),
        IS_LESS_THAN(Labels::getIsLessThan),
        IS_LESS_THAN_OR_EQUAL_TO(Labels::getIsLessThanOrEqualTo),
        IS_LIKE(Labels::getIsLike),
        IS_NOT_LIKE(Labels::getIsNotLike),
        IS_BETWEEN(Labels::getIsBetween),
        IS_NULL(Labels::getIsNull),
        IS_NOT_NULL(Labels::getIsNotNull);

        private Function<Labels, String> renderingStringFunction;

        private GenericConditionType(Function<Labels, String> renderingStringFunction) {
            this.renderingStringFunction = renderingStringFunction;
        }

        public String getRenderingString(BuildingContext context) {
            return this.renderingStringFunction.apply(context.getDialect().getLabels());
        }
    }
}

