/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.conditions;

import de.jaggl.sqlbuilder.conditions.CombinedCondition;
import de.jaggl.sqlbuilder.conditions.PlainCondition;
import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.domain.ConcatenationType;
import de.jaggl.sqlbuilder.domain.ConditionType;
import de.jaggl.sqlbuilder.utils.Indentation;

public abstract class Condition {
    private ConditionType type;
    private ConcatenationType concatenation;

    protected abstract String doBuild(BuildingContext var1, Indentation var2);

    public String build(BuildingContext context, boolean concatenate, Indentation indentation) {
        StringBuilder builder = new StringBuilder();
        if (concatenate) {
            builder.append(this.concatenation == ConcatenationType.AND ? context.getDialect().getLabels().getAnd() : context.getDialect().getLabels().getOr());
        }
        if (this.type == ConditionType.WHERE_NOT) {
            builder.append(" ").append(context.getDialect().getLabels().getNot());
        }
        if (concatenate) {
            if (indentation.isEnabled() && CombinedCondition.class.isAssignableFrom(this.getClass())) {
                builder.append(context.getDelimiter());
            } else {
                builder.append(" ");
            }
        }
        builder.append(this.doBuild(context, indentation));
        return builder.toString();
    }

    public Condition and(Condition other) {
        return this.append(other, ConcatenationType.AND, ConditionType.WHERE);
    }

    public Condition or(Condition other) {
        return this.append(other, ConcatenationType.OR, ConditionType.WHERE);
    }

    public Condition andNot(Condition other) {
        return this.append(other, ConcatenationType.AND, ConditionType.WHERE_NOT);
    }

    public Condition orNot(Condition other) {
        return this.append(other, ConcatenationType.OR, ConditionType.WHERE_NOT);
    }

    public Condition append(Condition other, ConcatenationType concatenationType, ConditionType conditionType) {
        other.setConcatenation(concatenationType);
        other.setType(conditionType);
        CombinedCondition combined = !CombinedCondition.class.isAssignableFrom(this.getClass()) ? new CombinedCondition(this) : (CombinedCondition)this;
        combined.append(other);
        return combined;
    }

    public static Condition plain(String plainCondition) {
        return new PlainCondition(plainCondition);
    }

    public ConditionType getType() {
        return this.type;
    }

    public ConcatenationType getConcatenation() {
        return this.concatenation;
    }

    public void setType(ConditionType type) {
        this.type = type;
    }

    public void setConcatenation(ConcatenationType concatenation) {
        this.concatenation = concatenation;
    }

    public String toString() {
        return "Condition(type=" + this.getType() + ", concatenation=" + this.getConcatenation() + ")";
    }
}

