/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.conditions;

import de.jaggl.sqlbuilder.conditions.Condition;
import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.utils.Indentation;
import java.util.ArrayList;
import java.util.List;

public class CombinedCondition
extends Condition {
    private List<Condition> conditions = new ArrayList<Condition>();

    public CombinedCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void append(Condition condition) {
        this.conditions.add(condition);
    }

    @Override
    protected String doBuild(BuildingContext context, Indentation indentation) {
        StringBuilder builder = new StringBuilder();
        builder.append(indentation.deIndent().getIndent()).append("(");
        if (indentation.isEnabled()) {
            builder.append(context.getDelimiter());
        }
        boolean isFirst = true;
        for (Condition condition : this.conditions) {
            if (!isFirst) {
                builder.append(context.getDelimiter());
            }
            builder.append(indentation.getIndent()).append(condition.build(context, !isFirst, indentation.indent()));
            isFirst = false;
        }
        if (indentation.isEnabled()) {
            builder.append(context.getDelimiter()).append(indentation.deIndent().getIndent());
        }
        builder.append(")");
        return builder.toString();
    }

    public static Condition getCopy(Condition condition) {
        if (condition == null) {
            return null;
        }
        if (CombinedCondition.class.isAssignableFrom(condition.getClass())) {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            for (Condition subCondition : ((CombinedCondition)condition).getConditions()) {
                conditions.add(CombinedCondition.getCopy(subCondition));
            }
            CombinedCondition copy = new CombinedCondition();
            copy.conditions = conditions;
            copy.setType(condition.getType());
            copy.setConcatenation(condition.getConcatenation());
            return copy;
        }
        return condition;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public String toString() {
        return "CombinedCondition(super=" + super.toString() + ", conditions=" + this.getConditions() + ")";
    }

    private CombinedCondition() {
    }
}

