/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.columns;

import de.jaggl.sqlbuilder.columns.ColumnDefinition;
import de.jaggl.sqlbuilder.conditions.Condition;
import de.jaggl.sqlbuilder.conditions.GenericCondition;
import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.domain.Definable;
import de.jaggl.sqlbuilder.domain.Groupable;
import de.jaggl.sqlbuilder.domain.Selectable;
import de.jaggl.sqlbuilder.schema.Table;
import de.jaggl.sqlbuilder.utils.BuilderUtils;
import de.jaggl.sqlbuilder.utils.Indentation;

public abstract class Column
implements Groupable,
Selectable,
Definable {
    protected Table table;
    protected String name;
    private String alias;
    protected ColumnDefinition columnDefinition;

    @Override
    public String getValue(BuildingContext context, Indentation indentation) {
        return this.getFullNameOrAlias(context);
    }

    public String getFullName(BuildingContext context) {
        return this.table.getFullName(context) + "." + BuilderUtils.columnApostrophe(this.name, context);
    }

    public String getFullNameOrAlias(BuildingContext context) {
        return this.table.getFullNameOrAlias(context) + "." + BuilderUtils.columnApostrophe(this.name, context);
    }

    public Condition isNull() {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_NULL, this);
    }

    public Condition isNotNull() {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_NULL, this);
    }

    public Condition isEqualTo(Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_EQUAL_TO, this, otherColumn);
    }

    public Condition isNotEqualTo(Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_EQUAL_TO, this, otherColumn);
    }

    public Column(Table table, String name, String alias, ColumnDefinition columnDefinition) {
        this.table = table;
        this.name = name;
        this.alias = alias;
        this.columnDefinition = columnDefinition;
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public ColumnDefinition getColumnDefinition() {
        return this.columnDefinition;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", alias=" + this.getAlias() + ", columnDefinition=" + this.getColumnDefinition() + ")";
    }
}

