package de.ixilon.wms.exception;

import java.io.IOException;

import net.opengis.ogc.ServiceExceptionType;

public class ServiceException extends IOException {

  private static final long serialVersionUID = 1L;
  private final ServiceExceptionType serviceExceptionType;

  protected ServiceException(ServiceExceptionType serviceExceptionType) {
    super(serviceExceptionType.getValue());
    this.serviceExceptionType = serviceExceptionType;
  }

  public static ServiceException of(ServiceExceptionType serviceExceptionType) {
    String code = serviceExceptionType.getCode();
    if (code != null) {
      switch (code) {
      case "InvalidFormat":
        return new InvalidFormatException(serviceExceptionType);
      case "InvalidCRS":
        return new InvalidCRSException(serviceExceptionType);
      case "LayerNotDefined":
        return new LayerNotDefinedException(serviceExceptionType);
      case "StyleNotDefined":
        return new StyleNotDefinedException(serviceExceptionType);
      case "LayerNotQueryable":
        return new LayerNotQueryableException(serviceExceptionType);
      case "InvalidPoint":
        return new InvalidPointException(serviceExceptionType);
      case "CurrentUpdateSequence":
        return new CurrentUpdateSequenceException(serviceExceptionType);
      case "InvalidUpdateSequence":
        return new InvalidUpdateSequenceException(serviceExceptionType);
      case "MissingBBox":
      case "MissingDimensionValue":
      case "MissingOrInvalidParameter":
      case "MissingParameterValue":
        return new MissingParameterValueException(serviceExceptionType);
      case "InvalidDimensionValue":
        return new InvalidDimensionValueException(serviceExceptionType);
      case "OperationNotSupported":
        return new OperationNotSupportedException(serviceExceptionType);
      }
    }
    return new ServiceException(serviceExceptionType);
  }

  public String getCode() {
    return serviceExceptionType.getCode();
  }

  public String getLocator() {
    return serviceExceptionType.getLocator();
  }

}
