package de.ixilon.wms;

import java.io.IOException;

import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.client.RestClientException;

import de.ixilon.wms.exception.ServiceException;
import net.opengis.ogc.ServiceExceptionReport;
import net.opengis.ogc.ServiceExceptionType;

class ServiceExceptionParser {

  private static final JaxbConverter<ServiceExceptionReport> converter = new JaxbConverter<>(ServiceExceptionReport.class);

  public static void checkException(HttpInputMessage inputMessage) throws IOException {
    final ServiceExceptionReport report;
    
    try {
      report = converter.readInternal(ServiceExceptionReport.class, inputMessage);
    } catch (HttpMessageNotReadableException exception) {
      return;
    }
    
    for (ServiceExceptionType type : report.getServiceException()) {
      throw ServiceException.of(type);
    }
  }

  public static void checkException(RestClientException exception) throws ServiceException {
    Throwable cause = exception.getCause();
    if (cause instanceof ServiceException) {
      throw (ServiceException) exception.getCause();
    }
  }

}
