package de.ixilon.wms;

import java.io.IOException;

import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

import net.opengis.wms.WMSCapabilities;

class MetadataResponseConverter extends AbstractHttpMessageConverter<WMSCapabilities> {
  
  private final JaxbConverter<WMSCapabilities> converter= new JaxbConverter<>(WMSCapabilities.class);

  public MetadataResponseConverter() {
    super(MediaType.TEXT_XML);
  }

  @Override
  protected boolean supports(Class<?> clazz) {
    return clazz.isAssignableFrom(WMSCapabilities.class);
  }
  
  @Override
  protected WMSCapabilities readInternal(Class<? extends WMSCapabilities> clazz, HttpInputMessage inputMessage)
      throws IOException, HttpMessageNotReadableException {
    inputMessage = new BufferingHttpInputMessage(inputMessage);
    try {
      return converter.readInternal(WMSCapabilities.class, inputMessage);
    } catch (HttpMessageNotReadableException exception) {
      ServiceExceptionParser.checkException(inputMessage);
      throw exception;
    }
  }

  @Override
  protected void writeInternal(WMSCapabilities t, HttpOutputMessage outputMessage)
      throws IOException, HttpMessageNotWritableException {
    converter.writeInternal(t, outputMessage);
  }

}
