package de.ixilon.wms;

import java.io.IOException;

import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

class MediaResponseConverter extends AbstractHttpMessageConverter<MediaResponse> {

  public MediaResponseConverter(MediaRequest request) {
    super(request.getMediaType(), MediaType.TEXT_XML);
  }

  @Override
  protected boolean supports(Class<?> clazz) {
    return clazz.isAssignableFrom(MediaResponse.class);
  }

  @Override
  protected MediaResponse readInternal(Class<? extends MediaResponse> clazz, HttpInputMessage inputMessage)
      throws IOException, HttpMessageNotReadableException {
    inputMessage = new BufferingHttpInputMessage(inputMessage);
    ServiceExceptionParser.checkException(inputMessage);
    return new MediaResponse(inputMessage);
  }

  @Override
  protected void writeInternal(MediaResponse t, HttpOutputMessage outputMessage)
      throws IOException, HttpMessageNotWritableException {
    throw new HttpMessageNotWritableException(t.getClass().getSimpleName() + " not supported");
  }

}
