package de.ixilon.wms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.util.StreamUtils;

/**
 * Wrapper for a {@link HttpInputMessage} that buffers all streams in memory.
 *
 * <p>
 * Using this wrapper allows for multiple reads of the
 * {@link HttpInputMessage#getBody()} response body.
 */
class BufferingHttpInputMessage implements HttpInputMessage {

  private final HttpInputMessage inputMessage;
  private byte[] buffer;

  public BufferingHttpInputMessage(HttpInputMessage inputMessage) {
    this.inputMessage = inputMessage;
  }

  @Override
  public HttpHeaders getHeaders() {
    return inputMessage.getHeaders();
  }

  @Override
  public synchronized InputStream getBody() throws IOException {
    if (buffer == null) {
      buffer = StreamUtils.copyToByteArray(inputMessage.getBody());
    }
    return new ByteArrayInputStream(buffer);
  }
  
}
