/*
 * Decompiled with CFR 0.152.
 */
package de.ixilon.instrument;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Arrays;
import sun.misc.IOUtils;

public class PatchAgent
implements ClassFileTransformer {
    private final ClassLoader classLoader;

    public PatchAgent() {
        URL url;
        String name = PatchAgent.toPath(this.getClass().getName()) + ".class";
        String path = this.getClass().getResource(name).getPath();
        String prefix = "jar:" + path.substring(0, path.indexOf("!") + 2);
        try {
            url = new URL(prefix);
        }
        catch (MalformedURLException exception) {
            throw new IllegalStateException(exception);
        }
        this.classLoader = new URLClassLoader(new URL[]{url});
    }

    private static String toPath(String name) {
        return "/" + Joiner.on((String)"/").join(Arrays.asList(name.split("\\.")));
    }

    public static void premain(String argument, Instrumentation instrumentation) {
        PatchAgent.agentmain(argument, instrumentation);
    }

    public static void agentmain(String argument, Instrumentation instrumentation) {
        instrumentation.addTransformer(new PatchAgent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String path = "/" + className + ".class";
        try (InputStream input = this.classLoader.getResourceAsStream(path);){
            if (input == null) return null;
            byte[] byArray = IOUtils.readFully((InputStream)input, (int)-1, (boolean)true);
            return byArray;
        }
        catch (IOException exception) {
            throw new IllegalClassFormatException(path);
        }
    }
}

