/*
 * Decompiled with CFR 0.152.
 */
package de.ixilon.osm.api;

import de.ixilon.jaxb.JaxbConverter;
import de.ixilon.osm.schema.ObjectFactory;
import de.ixilon.osm.schema.OsmRoot;
import java.net.URI;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OverpassClient {
    private final RestTemplate restTemplate;
    private final URI url;

    public OverpassClient(URI url) {
        this(url, new RestTemplate());
    }

    public OverpassClient(URI url, RestTemplate restTemplate) {
        JaxbConverter<OsmRoot> converter = new JaxbConverter<OsmRoot>(OsmRoot.class, ObjectFactory.class);
        this.url = url;
        this.restTemplate = restTemplate;
        this.restTemplate.getMessageConverters().add(converter);
    }

    public OsmRoot get(String query) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this.url);
        builder.query(query);
        return (OsmRoot)this.restTemplate.getForEntity(builder.build().encode().toUri(), OsmRoot.class).getBody();
    }

    public OsmRoot post(String query) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        HttpEntity request = new HttpEntity((Object)query, (MultiValueMap)headers);
        return (OsmRoot)this.restTemplate.exchange(this.url, HttpMethod.POST, request, OsmRoot.class).getBody();
    }
}

