/*
 * Decompiled with CFR 0.152.
 */
package de.ixilon.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class JaxbConverter<T>
extends AbstractHttpMessageConverter<T> {
    private final Class<T> clazz;
    private final Unmarshaller unmarshaller;
    private final Marshaller marshaller;

    public JaxbConverter(Class<T> clazz, Class<?> factory) {
        super(new MediaType[]{MediaType.TEXT_XML, MediaType.APPLICATION_XML, new MediaType("application", "*+xml")});
        this.clazz = clazz;
        try {
            JAXBContext context = JAXBContextFactory.createContext((Class[])new Class[]{factory}, null);
            this.unmarshaller = context.createUnmarshaller();
            this.marshaller = context.createMarshaller();
        }
        catch (JAXBException exception) {
            throw new IllegalArgumentException(clazz.getName(), exception);
        }
    }

    protected boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(this.clazz);
    }

    protected T readInternal(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        try {
            JAXBElement response = (JAXBElement)this.unmarshaller.unmarshal(inputMessage.getBody());
            return (T)response.getValue();
        }
        catch (JAXBException exception) {
            throw new HttpMessageNotReadableException("unmarshall error", (Throwable)exception);
        }
    }

    protected void writeInternal(T object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            this.marshaller.marshal(object, outputMessage.getBody());
        }
        catch (JAXBException exception) {
            throw new HttpMessageNotWritableException("marshall error", (Throwable)exception);
        }
    }
}

