package de.ixilon.osm.api;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import de.ixilon.jaxb.JaxbConverter;
import de.ixilon.osm.schema.ObjectFactory;
import de.ixilon.osm.schema.Osm;

public class OverpassClient {

  private final RestTemplate restTemplate;
  private final URI url;

  public OverpassClient(URI url) {
    this(url, new RestTemplate());
  }

  public OverpassClient(URI url, RestTemplate restTemplate) {
    this.url = url;
    this.restTemplate = restTemplate;
    this.restTemplate.setMessageConverters(messageConverters());
  }

  private static List<HttpMessageConverter<?>> messageConverters() {
    List<HttpMessageConverter<?>> converters = new ArrayList<>();
    converters.add(new JaxbConverter<Osm>(Osm.class, ObjectFactory.class));
    converters.add(new StringHttpMessageConverter());
    return converters;
  }

  public Osm get(String query) {
    UriComponentsBuilder builder = UriComponentsBuilder.fromUri(url);
    builder.query(query);
    return restTemplate.getForEntity(builder.build().encode().toUri(), Osm.class).getBody();
  }

  public Osm post(String query) {
    HttpHeaders headers = new HttpHeaders();
    headers.setContentType(MediaType.APPLICATION_XML);
    HttpEntity<String> request = new HttpEntity<>(query, headers);
    return restTemplate.exchange(url, HttpMethod.POST, request, Osm.class).getBody();
  }

}
