/*
 * Decompiled with CFR 0.152.
 */
package de.ixilon.starter.etag;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;

public class EtagHeaderFilter
extends OncePerRequestFilter {
    private final String etag;

    public EtagHeaderFilter(String etag) {
        this.etag = etag;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String method = request.getMethod();
        if (HttpMethod.GET.matches(method) || HttpMethod.HEAD.matches(method)) {
            response.addHeader("ETag", this.etag);
            if (this.etag.equals(request.getHeader("If-None-Match"))) {
                response.setStatus(304);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

