/*
 * Decompiled with CFR 0.152.
 */
package de.itagile.mediatype.simpleJson;

import de.itagile.mediatype.MediaType;
import de.itagile.mediatype.simpleJson.JsonFormat;
import de.itagile.model.Key;
import de.itagile.model.Model;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;

public class MediaTypeSetField
implements Key<Set<Model>>,
JsonFormat {
    private final String name;
    private final MediaType<JSONObject, JsonFormat> mediaType;

    public MediaTypeSetField(String name, MediaType<JSONObject, JsonFormat> mediaType) {
        this.name = name;
        this.mediaType = mediaType;
    }

    @Override
    public Set<Model> getUndefined() {
        return null;
    }

    @Override
    public void transform(Model e, JSONObject result) {
        Set<Model> entities = e.get(this);
        if (entities == null) {
            return;
        }
        HashSet<JSONObject> set = new HashSet<JSONObject>();
        result.put((Object)this.name, set);
        for (Model entity : entities) {
            JSONObject kv = this.mediaType.modify(entity);
            set.add(kv);
        }
    }

    public void spec(Map spec) {
        spec.put("name", this.name);
        HashMap<String, String> type = new HashMap<String, String>();
        type.put("name", "MediaTypeSet");
        type.put("mediatype", this.mediaType.getName());
        spec.put("type", type);
    }
}

