/*
 * Decompiled with CFR 0.152.
 */
package de.itagile.mediatype.simpleJson;

import de.itagile.mediatype.simpleJson.JsonFormat;
import de.itagile.model.Key;
import de.itagile.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;

public class EnumSetField<T extends Enum>
implements Key<Set<T>>,
JsonFormat {
    private final String name;
    private final T undefined;
    private final Collection<T> keys;

    public EnumSetField(String name, T undefined, T ... keys) {
        this.name = name;
        this.undefined = undefined;
        this.keys = Arrays.asList(keys);
    }

    @Override
    public void transform(Model e, JSONObject result) {
        Set entities = (Set)e.get(this);
        if (entities == null) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        for (Enum entity : entities) {
            if (!this.keys.contains(entity)) {
                entity = this.undefined;
            }
            set.add(entity.name());
        }
        result.put((Object)this.name, set);
    }

    public void spec(Map spec) {
        HashMap<String, Object> type = new HashMap<String, Object>();
        type.put("default", ((Enum)this.undefined).toString());
        type.put("name", "EnumSet");
        type.put("subtype", "String");
        ArrayList<String> values = new ArrayList<String>();
        for (Enum key : this.keys) {
            values.add(key.name());
        }
        type.put("values", values);
        spec.put("name", this.name);
        spec.put("type", type);
    }

    @Override
    public Set<T> getUndefined() {
        return null;
    }
}

