/*
 * Decompiled with CFR 0.152.
 */
package de.itagile.mediatype.simpleJson;

import de.itagile.mediatype.simpleJson.JsonFormat;
import de.itagile.model.Key;
import de.itagile.model.Model;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;

public class EnumField<T extends Enum>
implements Key<T>,
JsonFormat {
    public final String name;
    private final T undefined;
    private final Set<T> keys;

    public EnumField(String name, T undefined, Set<T> keys) {
        this.name = name;
        this.undefined = undefined;
        this.keys = keys;
    }

    @Override
    public T getUndefined() {
        return this.undefined;
    }

    @Override
    public void transform(Model e, JSONObject result) {
        Object value = (Enum)e.get(this);
        if (!this.keys.contains(value)) {
            value = this.getUndefined();
        }
        result.put((Object)this.name, (Object)((Enum)value).name());
    }

    public void spec(Map spec) {
        spec.put("name", this.name);
        HashMap<String, Object> type = new HashMap<String, Object>();
        type.put("name", "Enum");
        type.put("subtype", "String");
        type.put("default", ((Enum)this.undefined).toString());
        HashSet<String> values = new HashSet<String>();
        for (Enum key : this.keys) {
            values.add(key.toString());
        }
        type.put("values", values);
        spec.put("type", type);
    }
}

