/*
 * Decompiled with CFR 0.152.
 */
package de.itagile.mediatype;

import de.itagile.despot.DespotSpecParser;
import de.itagile.despot.EntityFactory;
import de.itagile.despot.ResponseModifier;
import de.itagile.mediatype.Format;
import de.itagile.model.Model;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;

public class MediaType<T, FormatType extends Format<T>>
implements Iterable<FormatType>,
EntityFactory<T>,
ResponseModifier {
    public static final String KEY = "produces";
    private final Set<FormatType> mediaTypes = new HashSet<FormatType>();
    private final String name;
    private final EntityFactory<T> entityFactory;

    public MediaType(String name, EntityFactory<T> entityFactory, FormatType ... types) {
        this.name = name;
        this.entityFactory = entityFactory;
        this.mediaTypes.addAll(Arrays.asList(types));
    }

    public static DespotSpecParser.NodeFactory createNode(final Map mediaTypeSpec) {
        return new DespotSpecParser.NodeFactory(){

            @Override
            public DespotSpecParser.Node create(Map<String, Object> result, Object value, DespotSpecParser.NodeFactoryMap extensionFields) {
                return new MediaTypeNode(result, value.toString(), mediaTypeSpec, MediaType.KEY);
            }
        };
    }

    public T modify(Model source) {
        T target = this.create();
        for (Format key : this) {
            key.transform(source, target);
        }
        return target;
    }

    @Override
    public Iterator<FormatType> iterator() {
        return new Iterator<FormatType>(){
            private final Iterator<FormatType> iterator;
            {
                this.iterator = MediaType.this.mediaTypes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public FormatType next() {
                return (Format)this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public Map getSpec() {
        HashMap<String, Object> spec = new HashMap<String, Object>();
        spec.put("name", this.name);
        HashSet<HashMap<String, Object>> fields = new HashSet<HashMap<String, Object>>();
        for (Format format : this.mediaTypes) {
            HashMap<String, Object> subSpec = new HashMap<String, Object>();
            format.spec(subSpec);
            fields.add(subSpec);
        }
        spec.put("fields", fields);
        return spec;
    }

    public String toString() {
        return "MediaType{name='" + this.name + '\'' + '}';
    }

    @Override
    public T create() {
        return this.entityFactory.create();
    }

    @Override
    public void modify(Response.ResponseBuilder responseBuilder, Model model) throws Exception {
        T entity = this.modify(model);
        responseBuilder.entity(entity).type(this.name);
    }

    @Override
    public void spec(Map<String, Object> spec) {
        spec.put(KEY, this.getSpec());
    }

    public static class MediaTypeNode
    implements DespotSpecParser.Node {
        private final Map<String, Object> parent;
        private final Map mediaTypeSpec;
        private final String key;
        private String value;

        public MediaTypeNode(Map<String, Object> parent, String value, Map mediaTypeSpec, String key) {
            this.parent = parent;
            this.value = value;
            this.mediaTypeSpec = mediaTypeSpec;
            this.key = key;
        }

        @Override
        public void call() {
            Set mediatypes = (Set)this.mediaTypeSpec.get("mediatypes");
            Map mediaType = this.findMediaTypeByName(this.value, mediatypes);
            if (Collections.emptyMap().equals(mediaType)) {
                this.parent.put(this.key, this.value);
            } else {
                this.parent.put(this.key, mediaType);
            }
        }

        private Map findMediaTypeByName(String name, Set<Map> mediatypes) {
            if (mediatypes == null) {
                return Collections.emptyMap();
            }
            for (Map mediatype : mediatypes) {
                if (!name.equals(mediatype.get("name"))) continue;
                return mediatype;
            }
            return Collections.emptyMap();
        }

        @Override
        public Iterator<DespotSpecParser.Node> iterator() {
            return Collections.emptyIterator();
        }
    }
}

