/*
 * Decompiled with CFR 0.152.
 */
package de.itagile.despot.http;

import de.itagile.despot.ResponseModifier;
import de.itagile.model.Model;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;

public class MaxAgeModifier
implements ResponseModifier {
    private static final String KEY = "max-age";
    private final long duration;
    private final TimeUnit timeUnit;

    private MaxAgeModifier(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public static MaxAgeModifier maxAge(int duration, TimeUnit timeUnit) {
        return new MaxAgeModifier(duration, timeUnit);
    }

    private CacheControl cacheHeader(long duration, TimeUnit timeUnit) {
        CacheControl cc = new CacheControl();
        Long l = timeUnit.toSeconds(duration);
        cc.setMaxAge(l.intValue());
        return cc;
    }

    @Override
    public void modify(Response.ResponseBuilder responseBuilder, Model model) {
        responseBuilder.cacheControl(this.cacheHeader(this.duration, this.timeUnit));
    }

    @Override
    public void spec(Map<String, Object> spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("duration", "" + this.duration);
        map.put("time-unit", this.timeUnit.name());
        spec.put(KEY, map);
    }

    public String toString() {
        return "Max-Age = " + this.duration + " seconds";
    }
}

