/*
 * Decompiled with CFR 0.152.
 */
package de.itagile.despot.http;

import de.itagile.despot.ResponseModifier;
import de.itagile.model.Key;
import de.itagile.model.Model;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class LocationModifier
implements ResponseModifier {
    public static final Key<LocationBuilder> KEY = new Key<LocationBuilder>(){

        @Override
        public LocationBuilder getUndefined() {
            return new LocationBuilder(){

                @Override
                public URI build(Iterable<String> vars) {
                    throw new IllegalStateException();
                }

                @Override
                public LocationBuilder put(String var, String value) {
                    return this;
                }
            };
        }
    };
    private final Iterable<String> segmentVars;

    private LocationModifier(Iterable<String> segmentVars) {
        this.segmentVars = segmentVars;
    }

    public static ValidLocationBuilder locationBuilder(UriInfo uriInfo) {
        return new ValidLocationBuilder(uriInfo.getBaseUriBuilder());
    }

    public static ValidLocationBuilder locationBuilder(UriBuilder uriBuilder) {
        return new ValidLocationBuilder(uriBuilder);
    }

    public static ResponseModifier location(String[] vars, String ... additionalVars) {
        ArrayList<String> segmentVars = new ArrayList<String>();
        LocationModifier.addNonEmpty(segmentVars, vars);
        LocationModifier.addNonEmpty(segmentVars, additionalVars);
        return new LocationModifier(segmentVars);
    }

    public static ResponseModifier location(String first, String ... additionalVars) {
        return LocationModifier.location(new String[]{first}, additionalVars);
    }

    private static void addNonEmpty(List<String> segmentVars, String ... vars) {
        for (String var : vars) {
            if (var == null || var.trim().isEmpty()) continue;
            segmentVars.add(var);
        }
    }

    @Override
    public void spec(Map<String, Object> spec) {
        String locationTemplate = "{base}";
        for (String segmentVar : this.segmentVars) {
            locationTemplate = locationTemplate + "/" + segmentVar;
        }
        spec.put("location", locationTemplate);
    }

    @Override
    public void modify(Response.ResponseBuilder responseBuilder, Model model) throws Exception {
        LocationBuilder locationBuilder = model.get(KEY);
        responseBuilder.location(locationBuilder.build(this.segmentVars));
    }

    public String toString() {
        return "Location: " + Arrays.asList(this.segmentVars);
    }

    public static class ValidLocationBuilder
    implements LocationBuilder {
        private final Map<String, String> replacements = new HashMap<String, String>();
        private final UriBuilder uriBuilder;

        private ValidLocationBuilder(UriBuilder uriBuilder) {
            this.uriBuilder = uriBuilder;
        }

        @Override
        public URI build(Iterable<String> vars) {
            UriBuilder builder = this.uriBuilder;
            for (String var : vars) {
                builder = builder.path(this.replace(var));
            }
            return builder.build(new Object[0]);
        }

        @Override
        public LocationBuilder put(String var, String value) {
            this.replacements.put(var, value);
            return this;
        }

        private String replace(String var) {
            if (this.replacements.containsKey(var)) {
                return this.replacements.get(var);
            }
            return var;
        }
    }

    public static interface LocationBuilder {
        public URI build(Iterable<String> var1);

        public LocationBuilder put(String var1, String var2);
    }
}

