/*
 * Decompiled with CFR 0.152.
 */
package de.itagile.despot;

import de.itagile.despot.Verification;
import de.itagile.despot.Verifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DespotVerifier
implements Verifier {
    private final Set<Map<String, Object>> specs = new HashSet<Map<String, Object>>();

    @Override
    public void add(Map<String, Object> spec) {
        this.specs.add(spec);
    }

    @Override
    public Verification verify(Set<Map<String, Object>> canonicalSpec) {
        HashSet<Map<String, Object>> specsCopy = new HashSet<Map<String, Object>>(this.specs);
        specsCopy.removeAll(canonicalSpec);
        if (!specsCopy.isEmpty()) {
            return new UnknownRoutes(specsCopy, canonicalSpec);
        }
        canonicalSpec.removeAll(this.specs);
        if (!canonicalSpec.isEmpty()) {
            return new UnreachableRoutes(canonicalSpec);
        }
        return new Verified();
    }

    private class UnreachableRoutes
    implements Verification {
        private final Set<Map<String, Object>> canonicalSpec;

        public UnreachableRoutes(Set<Map<String, Object>> canonicalSpec) {
            this.canonicalSpec = canonicalSpec;
        }

        @Override
        public boolean verified() {
            return false;
        }

        @Override
        public RuntimeException exception() {
            return new UnreachableRoutesException("Unreachable routes:\n" + this.canonicalSpec + "\ncannot be fulfilled by routes:\n" + DespotVerifier.this.specs);
        }
    }

    public static class UnknownRoutesException
    extends RuntimeException {
        public UnknownRoutesException(String message) {
            super(message);
        }
    }

    public static class UnreachableRoutesException
    extends RuntimeException {
        public UnreachableRoutesException(String message) {
            super(message);
        }
    }

    private static class UnknownRoutes
    implements Verification {
        private final Set<Map<String, Object>> specsCopy;
        private final Set<Map<String, Object>> canonicalSpec;

        public UnknownRoutes(Set<Map<String, Object>> specsCopy, Set<Map<String, Object>> canonicalSpec) {
            this.specsCopy = specsCopy;
            this.canonicalSpec = canonicalSpec;
        }

        @Override
        public boolean verified() {
            return false;
        }

        @Override
        public RuntimeException exception() {
            return new UnknownRoutesException("Unknown routes:\n" + this.specsCopy + "\ndo not fulfill the spec:\n" + this.canonicalSpec);
        }
    }

    private static class Verified
    implements Verification {
        private Verified() {
        }

        @Override
        public boolean verified() {
            return true;
        }

        @Override
        public RuntimeException exception() {
            return null;
        }
    }
}

