/*
 * Decompiled with CFR 0.152.
 */
package de.itagile.despot;

import de.itagile.despot.Method;
import de.itagile.despot.http.ConsumesSpecified;
import de.itagile.mediatype.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DespotSpecParser {
    public static final String RESPONSES = "responses";
    public static final String METHODS = "methods";
    public static final String METHOD = "method";
    public static final String URI = "uri";
    public static final String ENDPOINTS = "endpoints";

    private static Iterator<Node> mapIterator(Map input, final Map result, final NodeFactoryMap extensionFields) {
        final Iterator iterator = input.entrySet().iterator();
        return new Iterator<Node>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Node next() {
                Map.Entry next = (Map.Entry)iterator.next();
                Object value = next.getValue();
                String key = next.getKey().toString();
                if (extensionFields.contains(key)) {
                    return extensionFields.create(key, result, value, extensionFields);
                }
                if (value instanceof Map) {
                    return new AddMapToMapEntry(result, key, (Map)value, new HashMap(), extensionFields);
                }
                if (value instanceof Collection) {
                    return new AddSetToMapEntry(result, key, (Collection)value, extensionFields);
                }
                return new AddValueToMapEntry(result, key, value.toString());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    private static Iterator<Node> collectionIterator(Collection input, final Set result, final NodeFactoryMap extensionFields) {
        final Iterator iterator = input.iterator();
        return new Iterator<Node>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Node next() {
                Object value = iterator.next();
                if (value instanceof Map) {
                    return new AddMapToSetEntry(result, (Map)value, new HashMap(), extensionFields);
                }
                return new AddValueToSet(result, value.toString());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public Set<Map<String, Object>> getSpec(Method method, String uri, ConsumesSpecified.Consumes consumes, InputStream stream) throws IOException, ParseException {
        Map completeSpec = (Map)new JSONParser().parse((Reader)new InputStreamReader(stream));
        return this.getSpec(method, uri, consumes, completeSpec, completeSpec);
    }

    public Set<Map<String, Object>> getSpec(Method method, String uri, ConsumesSpecified.Consumes consumes, InputStream specStream, InputStream mediaTypeSpecStream) throws IOException, ParseException {
        Map completeSpec = (Map)new JSONParser().parse((Reader)new InputStreamReader(specStream));
        Map mediaTypeSpec = (Map)new JSONParser().parse((Reader)new InputStreamReader(mediaTypeSpecStream));
        return this.getSpec(method, uri, consumes, completeSpec, mediaTypeSpec);
    }

    private Set<Map<String, Object>> getSpec(Method method, String uri, ConsumesSpecified.Consumes consumes, Map completeSpec, Map mediaTypeSpec) {
        Set result = this.expand(this.normalize(completeSpec), this.normalize(mediaTypeSpec));
        HashSet<Transformation> transformations = new HashSet<Transformation>();
        transformations.add(ConsumesSpecified.createTransformation());
        return this.filter(this.transform(result, transformations), method, uri, consumes);
    }

    private Set<Map<String, Object>> transform(Set<Map<String, Object>> input, Set<Transformation> transformations) {
        HashSet<Map<String, Object>> result = new HashSet<Map<String, Object>>();
        for (Map<String, Object> spec : input) {
            for (Transformation transformation : transformations) {
                spec = transformation.transform(spec);
            }
            result.add(spec);
        }
        return result;
    }

    private Set<Map<String, Object>> filter(Set<Map<String, Object>> input, Method method, String uri, ConsumesSpecified.Consumes consumes) {
        HashSet<Map<String, Object>> result = new HashSet<Map<String, Object>>(input);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Map spec = (Map)iterator.next();
            if (!method.name().equals(spec.get(METHOD))) {
                iterator.remove();
                continue;
            }
            if (!uri.equals(spec.get(URI))) {
                iterator.remove();
                continue;
            }
            if (consumes.name().equals(spec.get("consumes"))) continue;
            iterator.remove();
        }
        return result;
    }

    public Map<String, Object> normalize(Map<String, Object> input) {
        RootEntry root = new RootEntry(input);
        this.walk(root);
        return root.result();
    }

    private void walk(Node root) {
        ArrayDeque<Node> commands = new ArrayDeque<Node>();
        ArrayDeque<Node> inputQueue = new ArrayDeque<Node>();
        inputQueue.add(root);
        while (!inputQueue.isEmpty()) {
            Node first = (Node)inputQueue.pop();
            commands.push(first);
            for (Node child : first) {
                inputQueue.add(child);
            }
        }
        while (!commands.isEmpty()) {
            ((Node)commands.pop()).call();
        }
    }

    public Set expand(Map input, Map mediaTypeSpec) {
        NodeFactoryMap extensionFields = new NodeFactoryMap();
        extensionFields.put(ENDPOINTS, ExpandNode.create(ENDPOINTS, METHODS));
        extensionFields.put(METHODS, ExpandNode.create(METHODS, RESPONSES));
        extensionFields.put("consumes", ConsumesSpecified.createNode(mediaTypeSpec));
        extensionFields.put("produces", MediaType.createNode(mediaTypeSpec));
        ExpandRoot root = new ExpandRoot(input, extensionFields);
        this.walk(root);
        return root.result();
    }

    private class RootEntry
    implements Node {
        private final Map map;
        private final Map result;
        private final NodeFactoryMap extensionFields;

        public RootEntry(Map input) {
            this.map = input;
            this.result = new HashMap();
            this.extensionFields = new NodeFactoryMap();
        }

        @Override
        public void call() {
        }

        @Override
        public Iterator<Node> iterator() {
            return DespotSpecParser.mapIterator(this.map, this.result, this.extensionFields);
        }

        public Map<String, Object> result() {
            return this.result;
        }
    }

    private static class ExpandRoot
    implements Node {
        private final Map input;
        private final NodeFactoryMap extensionFields;
        private final HashMap result;

        public ExpandRoot(Map input, NodeFactoryMap extensionFields) {
            this.input = input;
            this.extensionFields = extensionFields;
            this.result = new HashMap();
        }

        @Override
        public void call() {
        }

        @Override
        public Iterator<Node> iterator() {
            return DespotSpecParser.mapIterator(this.input, this.result, this.extensionFields);
        }

        public Set result() {
            return (Set)this.result.get(DespotSpecParser.ENDPOINTS);
        }
    }

    private static class ExpandNode
    extends AddSetToMapEntry {
        private final String expandTarget;

        private ExpandNode(Map parent, String key, Collection collection, NodeFactoryMap extensionFields, String expandTarget) {
            super(parent, key, collection, extensionFields);
            this.expandTarget = expandTarget;
        }

        public static NodeFactory create(final String key, final String expandTarget) {
            return new NodeFactory(){

                public Node create(Map result, Object value, NodeFactoryMap extensionFields) {
                    return new ExpandNode(result, key, (Collection)value, extensionFields, expandTarget);
                }
            };
        }

        @Override
        public void call() {
            HashSet result = new HashSet();
            for (Object map : ((AddSetToMapEntry)this).result) {
                HashMap newItem = new HashMap((Map)map);
                Set responses = (Set)newItem.get(this.expandTarget);
                newItem.remove(this.expandTarget);
                for (Map response : responses) {
                    response.putAll(newItem);
                }
                result.addAll(responses);
            }
            ((AddSetToMapEntry)this).parent.put(((AddSetToMapEntry)this).key, result);
        }
    }

    private static class AddMapToSetEntry
    implements Node {
        private final Collection parent;
        private final Map child;
        private final Map result;
        private final NodeFactoryMap extensionFields;

        private AddMapToSetEntry(Collection parent, Map child, Map result, NodeFactoryMap extensionFields) {
            this.parent = parent;
            this.child = child;
            this.result = result;
            this.extensionFields = extensionFields;
        }

        @Override
        public void call() {
            this.parent.add(this.result);
        }

        @Override
        public Iterator<Node> iterator() {
            return DespotSpecParser.mapIterator(this.child, this.result, this.extensionFields);
        }
    }

    private static class AddValueToSet
    implements Node {
        private final Set parent;
        private final String value;

        private AddValueToSet(Set parent, String value) {
            this.parent = parent;
            this.value = value;
        }

        @Override
        public void call() {
            this.parent.add(this.value);
        }

        @Override
        public Iterator<Node> iterator() {
            return Collections.emptyIterator();
        }
    }

    private static class AddSetToMapEntry
    implements Node {
        private final Map parent;
        private final String key;
        private final Collection collection;
        private final Set result;
        private final NodeFactoryMap extensionFields;

        private AddSetToMapEntry(Map parent, String key, Collection collection, NodeFactoryMap extensionFields) {
            this.parent = parent;
            this.key = key;
            this.collection = collection;
            this.extensionFields = extensionFields;
            this.result = new HashSet();
        }

        @Override
        public void call() {
            this.parent.put(this.key, this.result);
        }

        @Override
        public Iterator<Node> iterator() {
            return DespotSpecParser.collectionIterator(this.collection, this.result, this.extensionFields);
        }
    }

    private static class AddValueToMapEntry
    implements Node {
        private final Map parent;
        private final String key;
        private final String value;

        private AddValueToMapEntry(Map parent, String key, String value) {
            this.parent = parent;
            this.key = key;
            this.value = value;
        }

        @Override
        public void call() {
            if (!"__description__".equals(this.key)) {
                this.parent.put(this.key, this.value);
            }
        }

        @Override
        public Iterator<Node> iterator() {
            return Collections.emptyIterator();
        }
    }

    private static class AddMapToMapEntry
    implements Node {
        private final Map parent;
        private final String key;
        private final Map child;
        private final Map result;
        private final NodeFactoryMap extensionFields;

        private AddMapToMapEntry(Map parent, String key, Map child, Map result, NodeFactoryMap extensionFields) {
            this.parent = parent;
            this.key = key;
            this.child = child;
            this.result = result;
            this.extensionFields = extensionFields;
        }

        @Override
        public void call() {
            this.parent.put(this.key, this.result);
        }

        @Override
        public Iterator<Node> iterator() {
            return DespotSpecParser.mapIterator(this.child, this.result, this.extensionFields);
        }
    }

    public static class NodeFactoryMap {
        private Map<String, NodeFactory> map = new HashMap<String, NodeFactory>();

        public boolean contains(String key) {
            return this.map.containsKey(key);
        }

        public Node create(String key, Map result, Object value, NodeFactoryMap extensionFields) {
            return this.map.get(key).create(result, value, extensionFields);
        }

        public void put(String key, NodeFactory nodeFactory) {
            this.map.put(key, nodeFactory);
        }
    }

    public static interface Transformation {
        public Map<String, Object> transform(Map<String, Object> var1);
    }

    public static interface Node
    extends Iterable<Node> {
        public void call();

        @Override
        public Iterator<Node> iterator();
    }

    public static interface NodeFactory {
        public Node create(Map<String, Object> var1, Object var2, NodeFactoryMap var3);
    }
}

