/*
 * Decompiled with CFR 0.152.
 */
package de.ithappens.commons.usercontext;

import de.ithappens.commons.usercontext.Environment;
import de.ithappens.commons.usercontext.JavaEnvironment;
import de.ithappens.commons.usercontext.OperatingSystemEnvironment;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserContext {
    private static final UserContext SINGLETON = new UserContext();
    private final Map<Class, Environment> environments = new HashMap<Class, Environment>();

    private UserContext() {
        this.environments.put(OperatingSystemEnvironment.class, UserContext.createOperatingSystemEnvironment());
        this.environments.put(JavaEnvironment.class, UserContext.createJavaEnvironment());
    }

    public static OperatingSystemEnvironment createOperatingSystemEnvironment() {
        OperatingSystemEnvironment ose = new OperatingSystemEnvironment();
        ose.setSystemname(System.getProperty("os.name"));
        ose.setSystemversion(System.getProperty("os.version"));
        ose.setUsername(System.getProperty("user.name"));
        ose.setSystemarchitecture(System.getProperty("os.arch"));
        ose.setFileSeparator(System.getProperty("file.separator"));
        ose.setLineSeparator(System.getProperty("line.separator"));
        ose.setPathSeparator(System.getProperty("path.separator"));
        ose.setUserDir(System.getProperty("user.dir"));
        ose.setUserHome(System.getProperty("user.home"));
        ose.setSystemTempDirectory(System.getProperty("java.io.tmpdir"));
        return ose;
    }

    public static JavaEnvironment createJavaEnvironment() {
        JavaEnvironment je = new JavaEnvironment();
        je.setJavaVersion(System.getProperty("java.version"));
        je.setJavaLocation(System.getProperty("java.home"));
        je.setJavaVendor(System.getProperty("java.vendor"));
        je.setJavaVendorUrl(System.getProperty("java.vendor.url"));
        je.setJavaClassPath(System.getProperty("java.class.path"));
        return je;
    }

    public static UserContext getInstance() {
        return SINGLETON;
    }

    public Map<Class, Environment> getEnvironments() {
        return this.environments;
    }

    public void addEnvironment(Environment environment) {
        this.environments.put(environment.getClass(), environment);
    }

    public OperatingSystemEnvironment getOperatingSystemEnvironment() {
        return this.getEnvironment(OperatingSystemEnvironment.class);
    }

    public JavaEnvironment getJavaEnvironment() {
        return this.getEnvironment(JavaEnvironment.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Environment> T getEnvironment(Class<T> c) {
        Environment env = this.environments.get(c);
        if (env != null) {
            return (T)env;
        }
        try {
            Environment environment = (Environment)c.newInstance();
            return (T)environment;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(UserContext.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        finally {
            return null;
        }
    }
}

