/*
 * Decompiled with CFR 0.152.
 */
package de.ithappens.commons.usercontext;

import de.ithappens.commons.usercontext.Environment;
import java.math.BigDecimal;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.validator.routines.BigDecimalValidator;

public abstract class EnvironmentPreference
extends Environment {
    private Preferences STORAGE;

    public Preferences getSTORAGE() {
        if (this.STORAGE == null) {
            if (this.getContext().equals((Object)CONTEXT.USER)) {
                this.STORAGE = Preferences.userNodeForPackage(this.getClass());
            } else if (this.getContext().equals((Object)CONTEXT.INSTALLATION)) {
                this.STORAGE = Preferences.systemNodeForPackage(this.getClass());
            }
        }
        return this.STORAGE;
    }

    public abstract CONTEXT getContext();

    public void setStringAndEncrypt(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.STORAGE.putByteArray(key, value.getBytes());
    }

    public String getStringAndEncrypt(String key, String defaultValue) {
        byte[] byteArray = this.STORAGE.getByteArray(key, defaultValue != null ? defaultValue.getBytes() : null);
        return byteArray == null ? null : new String(byteArray);
    }

    public void setEmpty(String key) {
        this.setString(key, "");
    }

    public int get(String key, int defaultValue) {
        return this.getSTORAGE().getInt(key, defaultValue);
    }

    public void set(String key, int value) {
        this.getSTORAGE().putInt(key, value);
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        String value = this.getString(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return NumberUtils.isNumber((String)value) ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    public void setInteger(String key, Integer value) {
        this.setString(key, value == null ? null : Integer.toString(value));
    }

    public boolean get(String key, boolean defaultValue) {
        return this.getSTORAGE().getBoolean(key, defaultValue);
    }

    public void set(String key, boolean value) {
        this.getSTORAGE().putBoolean(key, value);
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return BooleanUtils.toBooleanObject((String)value);
    }

    public void setBoolean(String key, Boolean value) {
        this.setString(key, value == null ? null : Boolean.toString(value));
    }

    public double get(String key, double defaultValue) {
        return this.getSTORAGE().getDouble(key, defaultValue);
    }

    public void set(String key, double value) {
        this.getSTORAGE().putDouble(key, value);
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return NumberUtils.isNumber((String)value) ? Double.valueOf(Double.parseDouble(value)) : null;
    }

    public void setDouble(String key, Double value) {
        this.setString(key, value == null ? null : Double.toString(value));
    }

    public long get(String key, long defaultValue) {
        return this.getSTORAGE().getLong(key, defaultValue);
    }

    public void set(String key, long value) {
        this.getSTORAGE().putLong(key, value);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return NumberUtils.isNumber((String)value) ? Long.valueOf(Long.parseLong(value)) : null;
    }

    public void setLong(String key, Long value) {
        this.setString(key, value == null ? null : Long.toString(value));
    }

    public float get(String key, float defaultValue) {
        return this.getSTORAGE().getFloat(key, defaultValue);
    }

    public void set(String key, float value) {
        this.getSTORAGE().putFloat(key, value);
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return NumberUtils.isNumber((String)value) ? Float.valueOf(Float.parseFloat(value)) : null;
    }

    public void setFloat(String key, Float value) {
        this.setString(key, value == null ? null : Float.toString(value.floatValue()));
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return BigDecimalValidator.getInstance().validate(value);
    }

    public void setBigDecimal(String key, BigDecimal value) {
        this.setString(key, value == null ? null : value.toString());
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, Object defaultValue) {
        return this.getSTORAGE().get(key, defaultValue != null ? defaultValue.toString() : null);
    }

    public void setString(String key, String value) {
        if (value == null) {
            this.getSTORAGE().remove(key);
        } else {
            this.getSTORAGE().put(key, value);
        }
    }

    public static enum CONTEXT {
        USER,
        INSTALLATION;

    }
}

