/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.karmatestrunner.junit;

import de.is24.util.karmatestrunner.ExecutionServerConfigProvider;
import de.is24.util.karmatestrunner.JSTestExecutionServer;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

public class KarmaTestSuiteRunner
extends ParentRunner<String> {
    private RunnerScheduler fScheduler = new RunnerScheduler(){

        public void schedule(Runnable childStatement) {
            childStatement.run();
        }

        public void finished() {
        }
    };
    private JSTestExecutionServer jsTestExecutionServer;

    public KarmaTestSuiteRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        File configFile;
        ArrayList<String> karmaProcessArgs = new ArrayList<String>();
        ExecutionServerConfigProvider configProvider = new ExecutionServerConfigProvider(testClass);
        ArrayList<String> additionalKarmaProcessArgs = configProvider.getKarmaProcessArgs();
        ArrayList<String> karmaStartupScripts = configProvider.getKarmaStartupScripts();
        String karmaProcessName = configProvider.getKarmaProcessName();
        String karmaConfigPath = configProvider.getKarmaConfigPath();
        int karmaRemoteServerPort = configProvider.getKarmaRemoteServerPort();
        if (karmaStartupScripts.size() > 0) {
            for (String filePath : karmaStartupScripts) {
                File file = new File(filePath.trim());
                if (file.isFile() && file.canExecute()) {
                    karmaProcessArgs.add(file.getAbsolutePath());
                    continue;
                }
                if (!file.exists()) continue;
                System.err.println("File " + file.getAbsolutePath() + " is not executable");
            }
            if (karmaProcessArgs.isEmpty()) {
                throw new IllegalArgumentException("No executable file found: " + karmaStartupScripts);
            }
        } else {
            karmaProcessArgs.add(karmaProcessName);
            karmaProcessArgs.addAll(additionalKarmaProcessArgs);
        }
        if (!(configFile = new File(karmaConfigPath)).canRead()) {
            throw new IllegalArgumentException("Karma config file not readable: " + karmaConfigPath);
        }
        karmaProcessArgs.add(configFile.getAbsolutePath());
        System.out.println("Karma will be started with process builder args: " + karmaProcessArgs.toString());
        this.jsTestExecutionServer = new JSTestExecutionServer(karmaRemoteServerPort);
        this.jsTestExecutionServer.setKarmaStartCmd(karmaProcessArgs);
        this.jsTestExecutionServer.setTestClass(testClass);
    }

    private Statement afterTests(final Statement statement) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                KarmaTestSuiteRunner.this.jsTestExecutionServer.afterTests();
                statement.evaluate();
            }
        };
    }

    private Statement beforeTests(final Statement statement) {
        return new Statement(){

            public void evaluate() throws Throwable {
                KarmaTestSuiteRunner.this.jsTestExecutionServer.beforeTests();
                statement.evaluate();
            }
        };
    }

    protected Statement classBlock(RunNotifier notifier) {
        Statement statement = super.classBlock(notifier);
        statement = this.beforeTests(statement);
        statement = this.afterTests(statement);
        return statement;
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                KarmaTestSuiteRunner.this.runChildren(notifier);
            }
        };
    }

    private void runChildren(final RunNotifier notifier) {
        this.fScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                KarmaTestSuiteRunner.this.runChild(null, notifier);
            }
        });
        this.fScheduler.finished();
    }

    protected Description describeChild(String name) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)name);
    }

    protected List<String> getChildren() {
        ArrayList<String> names = new ArrayList<String>();
        return names;
    }

    protected void runChild(String name, RunNotifier notifier) {
        this.jsTestExecutionServer.runTests(notifier);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface KarmaRemoteServerPort {
        public int value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface KarmaConfigPath {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface KarmaStartupScripts {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface KarmaProcessArgs {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface KarmaProcessName {
        public String value();
    }
}

