/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.karmatestrunner.jetty;

import de.is24.util.karmatestrunner.TestReporter;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;

public class ResultReceiverServer
extends Server {
    WebSocket _websocket;
    SelectChannelConnector _connector = new SelectChannelConnector();
    WebSocketHandler _wsHandler;
    TestReporter reporter;

    public ResultReceiverServer(int port) {
        this._connector.setPort(port);
        this.addConnector((Connector)this._connector);
        this._wsHandler = new WebSocketHandler(){

            public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                if ("karma-test-results".equals(protocol)) {
                    ResultReceiverServer.this._websocket = new MyTestWebSocket();
                }
                return ResultReceiverServer.this._websocket;
            }
        };
        this.setHandler((Handler)this._wsHandler);
    }

    public void setTestReporter(TestReporter testReporter) {
        this.reporter = testReporter;
    }

    class MyTestWebSocket
    implements WebSocket,
    WebSocket.OnFrame,
    WebSocket.OnTextMessage,
    WebSocket.OnControl {
        protected WebSocket.FrameConnection _connection;

        MyTestWebSocket() {
        }

        public WebSocket.FrameConnection getConnection() {
            return this._connection;
        }

        public void onOpen(WebSocket.Connection connection) {
        }

        public void onHandshake(WebSocket.FrameConnection connection) {
            this._connection = connection;
        }

        public void onClose(int code, String message) {
        }

        public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
            return false;
        }

        public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
            return false;
        }

        public void onMessage(String data) {
            ResultReceiverServer.this.reporter.handleMessage(data);
        }
    }
}

