/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.karmatestrunner;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class TestReporter {
    private HashMap<String, String> browsers = new HashMap();
    private JSONParser parser = new JSONParser();
    private RunNotifier notifier;
    private Class<?> testClass;
    private Description suiteDescription;
    private ContainerFactory containerFactory = new ContainerFactory(){

        public List creatArrayContainer() {
            return new LinkedList();
        }

        public Map createObjectContainer() {
            return new LinkedHashMap();
        }
    };

    TestReporter(RunNotifier notifier) {
        this.notifier = notifier;
    }

    public void handleMessage(String data) {
        try {
            Map message = (Map)this.parser.parse(data, this.containerFactory);
            String message_type = (String)message.get("type");
            if (message_type.equalsIgnoreCase("test")) {
                this.reportTestResult(message);
            } else if (message_type.equalsIgnoreCase("browsers")) {
                this.setBrowsers(message);
            } else if (message_type.equalsIgnoreCase("runComplete")) {
                this.finishReportingForTestSuite();
            } else if (message_type.equalsIgnoreCase("browserError")) {
                this.reportBrowserError(message);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    private void finishReportingForTestSuite() {
        this.notifier.fireTestFinished(this.suiteDescription);
    }

    private void setBrowsers(Map browsers) {
        for (int i = 0; i < ((List)browsers.get("list")).size(); ++i) {
            Map browser = (Map)((List)browsers.get("list")).get(i);
            this.browsers.put((String)browser.get("browserId"), (String)browser.get("name"));
            this.suiteDescription = Description.createSuiteDescription(this.testClass);
            this.notifier.fireTestStarted(this.suiteDescription);
        }
    }

    private void reportBrowserError(Map message) {
        String browserId = (String)message.get("browserId");
        Description description = this.describeChild(this.testClass, this.browsers.get(browserId) + ": Browser Error");
        String errorMsg = message.get("error").toString();
        JSTestFailure failure = new JSTestFailure(description, "Error", "Failures: " + errorMsg);
        this.notifier.fireTestStarted(description);
        this.notifier.fireTestFailure((Failure)failure);
        this.notifier.fireTestFinished(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportTestResult(Map message) {
        String browserId = (String)message.get("browserId");
        Map result = (Map)message.get("result");
        Long time = (Long)result.get("time");
        Boolean skipped = (Boolean)result.get("skipped");
        String label = (String)result.get("description");
        Boolean success = (Boolean)result.get("success");
        String suite = result.get("suite").toString();
        Description description = this.describeChild(this.testClass, this.browsers.get(browserId) + ": " + suite + " " + label);
        try {
            if (skipped.booleanValue()) {
                this.notifier.fireTestIgnored(description);
            } else {
                this.notifier.fireTestStarted(description);
            }
            if (!success.booleanValue()) {
                String log = result.get("log").toString();
                JSTestFailure failure = new JSTestFailure(description, label, "Failures: " + log);
                this.notifier.fireTestFailure((Failure)failure);
            }
        }
        finally {
            this.notifier.fireTestFinished(description);
        }
    }

    private Description describeChild(Class browser, String description) {
        return Description.createTestDescription((Class)browser, (String)description);
    }

    private static class JSTestFailure
    extends Failure {
        private final String name;

        public JSTestFailure(Description description, String name, String message) {
            super(description, (Throwable)new RuntimeException(message));
            this.name = name;
        }

        public String getTestHeader() {
            return this.name;
        }

        public String getTrace() {
            return this.getMessage();
        }

        public String toString() {
            return this.getTestHeader();
        }
    }
}

