/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.karmatestrunner;

import de.is24.util.karmatestrunner.PortFinder;
import de.is24.util.karmatestrunner.TestReporter;
import de.is24.util.karmatestrunner.jetty.ResultReceiverServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.util.ArrayList;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JSTestExecutionServer {
    static final int MAX_RETRIES_TO_START_RESULT_RECEIVER_SERVER = 25;
    ResultReceiverServer server;
    int port;
    ArrayList<String> karmaProcessBuilderArgs;
    private Class<?> testClass;
    private boolean resultReceiverStarted = false;

    public JSTestExecutionServer(int port) {
        this.port = port;
    }

    public void beforeTests() throws Exception {
        this.tryToStartResultReceiverServer(25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTests(RunNotifier notifier) {
        TestReporter reporter = new TestReporter(notifier);
        reporter.setTestClass(this.testClass);
        if (!this.resultReceiverStarted) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.testClass), (Throwable)new RuntimeException("result receiver server could not be started....")));
            return;
        }
        this.server.setTestReporter(reporter);
        try {
            this.runKarma();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void afterTests() {
    }

    public void setKarmaStartCmd(ArrayList<String> args) {
        this.karmaProcessBuilderArgs = args;
    }

    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    private void tryToStartResultReceiverServer(int retries) throws Exception {
        if (retries == 0) {
            System.err.println("Maximum retries (25) to start the karma result receiver exceeded");
            return;
        }
        this.port = PortFinder.findFreePort(this.port);
        this.server = new ResultReceiverServer(this.port);
        try {
            this.server.start();
            this.resultReceiverStarted = true;
            this.karmaProcessBuilderArgs.add("--remoteReporterPort=" + this.port);
            System.out.println("Karma result receiver server startet at port: " + this.port);
        }
        catch (BindException e) {
            this.tryToStartResultReceiverServer(--retries);
        }
    }

    private void runKarma() throws Exception {
        String line;
        Process process;
        ProcessBuilder builder = new ProcessBuilder(this.karmaProcessBuilderArgs);
        builder.redirectErrorStream(true);
        builder.redirectOutput();
        try {
            process = builder.start();
        }
        catch (IOException e) {
            throw new IOException("error while starting karma: " + e.toString());
        }
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        System.out.println("Program terminated!");
    }
}

