/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.karmatestrunner;

import de.is24.util.karmatestrunner.junit.KarmaTestSuiteRunner;
import java.util.ArrayList;
import java.util.Arrays;

public class ExecutionServerConfigProvider {
    public static final String KARMA_PROCESS_NAME_SYSTEM_PROPERTY = "karma.process.name";
    public static final String KARMA_PROCESS_ARGS_SYSTEM_PROPERTY = "karma.process.args";
    public static final String KARMA_STARTUP_SCRIPTS_SYSTEM_PROPERTY = "karma.startup.scripts";
    public static final String KARMA_REMOTE_SERVER_PORT_SYSTEM_PROPERTY = "karma.remoteServerPort";
    public static final int DEFAULT_KARMA_REMOTE_SERVER_PORT = 9889;
    public static final ArrayList<String> DEFAULT_KARMA_PROCESS_ARGS = new ArrayList<String>(Arrays.asList("start"));
    public static final ArrayList<String> DEFAULT_KARMA_STARTUP_SCRIPTS = new ArrayList();
    public static final String DEFAULT_KARMA_CONFIG_PATH = "karma.conf.js";
    private final Class<?> testClass;

    public ExecutionServerConfigProvider(Class<?> testClass) {
        this.testClass = testClass;
    }

    public String getKarmaProcessName() {
        KarmaTestSuiteRunner.KarmaProcessName annotation = this.testClass.getAnnotation(KarmaTestSuiteRunner.KarmaProcessName.class);
        String resultAsString = System.getProperty(KARMA_PROCESS_NAME_SYSTEM_PROPERTY, annotation != null ? annotation.value() : "");
        if (resultAsString.isEmpty()) {
            if (System.getProperty("os.name", "").toLowerCase().contains("win")) {
                return "karma.cmd";
            }
            return "karma";
        }
        return resultAsString;
    }

    public ArrayList<String> getKarmaProcessArgs() {
        KarmaTestSuiteRunner.KarmaProcessArgs annotation = this.testClass.getAnnotation(KarmaTestSuiteRunner.KarmaProcessArgs.class);
        String resultAsString = System.getProperty(KARMA_PROCESS_ARGS_SYSTEM_PROPERTY, annotation != null ? annotation.value() : "");
        if (resultAsString.isEmpty()) {
            return DEFAULT_KARMA_PROCESS_ARGS;
        }
        return new ArrayList<String>(Arrays.asList(resultAsString.split(",")));
    }

    public ArrayList<String> getKarmaStartupScripts() {
        KarmaTestSuiteRunner.KarmaStartupScripts annotation = this.testClass.getAnnotation(KarmaTestSuiteRunner.KarmaStartupScripts.class);
        String resultAsString = System.getProperty(KARMA_STARTUP_SCRIPTS_SYSTEM_PROPERTY, annotation != null ? annotation.value() : "");
        if (resultAsString.isEmpty()) {
            return DEFAULT_KARMA_STARTUP_SCRIPTS;
        }
        return new ArrayList<String>(Arrays.asList(resultAsString.split(",")));
    }

    public String getKarmaConfigPath() {
        KarmaTestSuiteRunner.KarmaConfigPath annotation = this.testClass.getAnnotation(KarmaTestSuiteRunner.KarmaConfigPath.class);
        String resultAsString = annotation != null ? annotation.value() : "";
        return resultAsString.isEmpty() ? DEFAULT_KARMA_CONFIG_PATH : resultAsString;
    }

    public int getKarmaRemoteServerPort() {
        KarmaTestSuiteRunner.KarmaRemoteServerPort annotation = this.testClass.getAnnotation(KarmaTestSuiteRunner.KarmaRemoteServerPort.class);
        String resultAsString = System.getProperty(KARMA_REMOTE_SERVER_PORT_SYSTEM_PROPERTY, annotation != null ? annotation.value() + "" : "");
        return resultAsString.isEmpty() ? 9889 : Integer.parseInt(resultAsString);
    }
}

