/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.service;

import de.is24.common.infrastructure.security.CurrentClientNameProvider;
import de.is24.common.togglz.remote.api.RemoteFeature;
import de.is24.common.togglz.remote.api.RemoteFeatureState;
import de.is24.common.togglz.service.domain.FeatureState;
import de.is24.common.togglz.service.repo.FeatureStateRepository;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.user.SimpleFeatureUser;

@Component
public class RepositoryWritingFeatureManager
implements FeatureManager {
    @Autowired
    private FeatureStateRepository featureStateRepository;

    public String getName() {
        return "RepositoryWritingFeatureManager";
    }

    public Set<Feature> getFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        this.featureStateRepository.findAll().forEach(s -> features.add(s.getFeature()));
        return features;
    }

    public FeatureMetaData getMetaData(Feature feature) {
        if (feature instanceof RemoteFeature) {
            return (RemoteFeature)feature;
        }
        return null;
    }

    public boolean isActive(Feature feature) {
        return this.featureStateRepository.findByFeatureName(feature.name()).getEnabled();
    }

    public FeatureUser getCurrentFeatureUser() {
        return new SimpleFeatureUser(CurrentClientNameProvider.getCurrentClientName(), true);
    }

    public org.togglz.core.repository.FeatureState getFeatureState(Feature feature) {
        return RemoteFeatureState.toFeatureState(this.featureStateRepository.findByFeatureName(feature.name()));
    }

    public void setFeatureState(org.togglz.core.repository.FeatureState state) {
        FeatureState featureStateFromRepo = this.featureStateRepository.findByFeatureName(state.getFeature().name());
        RemoteFeatureState remoteFeatureState = RemoteFeatureState.from(state);
        if (featureStateFromRepo != null) {
            featureStateFromRepo.setFeature(remoteFeatureState.getFeature());
            featureStateFromRepo.setEnabled(remoteFeatureState.getEnabled());
            featureStateFromRepo.setStrategyId(remoteFeatureState.getStrategyId());
            featureStateFromRepo.setParameters(remoteFeatureState.getParameters());
            this.featureStateRepository.save(featureStateFromRepo);
        } else {
            this.featureStateRepository.save((FeatureState)remoteFeatureState);
        }
    }
}

