/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.remote.api;

import de.is24.common.togglz.remote.api.RemoteFeature;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.togglz.core.Feature;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.repository.FeatureState;

public class RemoteFeatureState
implements Serializable {
    public static final String REL = "featureStates";
    @NotNull
    private RemoteFeature feature;
    @NotNull
    private Boolean enabled;
    private String strategyId;
    private Map<String, String> parameters = new HashMap<String, String>();

    public static FeatureState toFeatureState(RemoteFeatureState remoteFeatureState) {
        FeatureState featureState = new FeatureState((Feature)remoteFeatureState.getFeature(), remoteFeatureState.getEnabled().booleanValue());
        featureState.setStrategyId(remoteFeatureState.getStrategyId());
        remoteFeatureState.getParameters().forEach((k, v) -> featureState.setParameter(k, v));
        return featureState;
    }

    public static RemoteFeatureState from(FeatureState featureState) {
        RemoteFeatureState remoteFeatureState = new RemoteFeatureState();
        RemoteFeature feature = new RemoteFeature();
        Feature featureFromGivenState = featureState.getFeature();
        feature.setName(featureFromGivenState.name());
        if (featureFromGivenState instanceof FeatureMetaData) {
            FeatureMetaData metaData = (FeatureMetaData)featureFromGivenState;
            feature.setLabel(metaData.getLabel());
            feature.setEnabledByDefault(metaData.isEnabledByDefault());
        }
        remoteFeatureState.setFeature(feature);
        remoteFeatureState.setEnabled(featureState.isEnabled());
        remoteFeatureState.setStrategyId(featureState.getStrategyId());
        remoteFeatureState.setParameters(new HashMap<String, String>(2));
        featureState.getParameterMap().forEach((k, v) -> remoteFeatureState.getParameters().put((String)k, (String)v));
        return remoteFeatureState;
    }

    public RemoteFeature getFeature() {
        return this.feature;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getStrategyId() {
        return this.strategyId;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setFeature(RemoteFeature feature) {
        this.feature = feature;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setStrategyId(String strategyId) {
        this.strategyId = strategyId;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFeatureState)) {
            return false;
        }
        RemoteFeatureState other = (RemoteFeatureState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RemoteFeature this$feature = this.getFeature();
        RemoteFeature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$strategyId = this.getStrategyId();
        String other$strategyId = other.getStrategyId();
        if (this$strategyId == null ? other$strategyId != null : !this$strategyId.equals(other$strategyId)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    public boolean canEqual(Object other) {
        return other instanceof RemoteFeatureState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RemoteFeature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 0 : ((Object)$feature).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 0 : ((Object)$enabled).hashCode());
        String $strategyId = this.getStrategyId();
        result = result * 59 + ($strategyId == null ? 0 : $strategyId.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 0 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "RemoteFeatureState(feature=" + this.getFeature() + ", enabled=" + this.getEnabled() + ", strategyId=" + this.getStrategyId() + ", parameters=" + this.getParameters() + ")";
    }
}

