/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.infrastructure.repo;

import de.is24.common.infrastructure.domain.DomainObject;
import de.is24.common.infrastructure.security.CurrentClientNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.rest.core.event.AbstractRepositoryEventListener;
import org.springframework.stereotype.Component;

@Component
public class RepositoryChangedLogger
extends AbstractRepositoryEventListener<DomainObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryChangedLogger.class);

    protected void onAfterCreate(DomainObject entity) {
        super.onAfterSave((Object)entity);
        this.logChange(entity, "CREATED");
    }

    protected void onAfterSave(DomainObject entity) {
        super.onAfterSave((Object)entity);
        this.logChange(entity, "SAVED");
    }

    protected void onAfterDelete(DomainObject entity) {
        super.onAfterDelete((Object)entity);
        this.logChange(entity, "DELETED");
    }

    private void logChange(DomainObject entity, String event) {
        LOGGER.info("{} entity {} #{}; Responsible client: {}", new Object[]{event, entity.getClass().getSimpleName(), entity.getId(), CurrentClientNameProvider.getCurrentClientName()});
    }
}

