/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.infrastructure.domain;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import de.is24.common.infrastructure.domain.DomainObject;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.data.annotation.Id;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class Client
implements UserDetails,
DomainObject {
    @Id
    private String name;
    private String accessKey;
    private List<String> roles;

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Lists.transform(this.roles, (Function)new Function<String, GrantedAuthority>(){

            public GrantedAuthority apply(@Nullable String role) {
                return new SimpleGrantedAuthority("ROLE_" + role);
            }
        });
    }

    public String getPassword() {
        return this.accessKey;
    }

    public String getUsername() {
        return this.name;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @ConstructorProperties(value={"name", "accessKey", "roles"})
    public Client(String name, String accessKey, List<String> roles) {
        this.name = name;
        this.accessKey = accessKey;
        this.roles = roles;
    }

    public String getName() {
        return this.name;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client other = (Client)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        List<String> this$roles = this.getRoles();
        List<String> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    public boolean canEqual(Object other) {
        return other instanceof Client;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 0 : $accessKey.hashCode());
        List<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 0 : ((Object)$roles).hashCode());
        return result;
    }

    public String toString() {
        return "Client(name=" + this.getName() + ", accessKey=" + this.getAccessKey() + ", roles=" + this.getRoles() + ")";
    }

    public Client() {
    }
}

