/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.infrastructure.config.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ReportingDateTimeSerializationModule
extends SimpleModule {
    public void setupModule(Module.SetupContext context) {
        SimpleSerializers serializers = new SimpleSerializers();
        SimpleDeserializers deserializers = new SimpleDeserializers();
        serializers.addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer());
        deserializers.addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        context.addSerializers((Serializers)serializers);
        context.addDeserializers((Deserializers)deserializers);
    }

    public static class DateTimeDeserializer
    extends JsonDeserializer<DateTime> {
        private static DateTimeFormatter formatter = ISODateTimeFormat.basicDateTime();

        public DateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return formatter.parseDateTime(jsonParser.getValueAsString());
        }
    }

    public static class DateTimeSerializer
    extends JsonSerializer<DateTime> {
        private static DateTimeFormatter formatter = ISODateTimeFormat.basicDateTime();

        public void serialize(DateTime value, JsonGenerator gen, SerializerProvider arg2) throws IOException, JsonProcessingException {
            gen.writeString(formatter.print((ReadableInstant)value));
        }
    }
}

