/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.infrastructure.config.security;

import com.google.common.collect.Lists;
import de.is24.common.infrastructure.config.security.PredefinedUser;
import de.is24.common.infrastructure.config.security.PredefinedUsers;
import de.is24.common.infrastructure.domain.Client;
import de.is24.common.infrastructure.repo.ClientRepository;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.servlet.configuration.EnableWebMvcSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;

@Configuration
@EnableConfigurationProperties(value={PredefinedUsers.class})
@EnableWebMvcSecurity
public class Security
extends WebSecurityConfigurerAdapter {
    private static final String ADMIN_ROLE = "ADMIN";
    @Autowired
    private PredefinedUsers predefinedUsers;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private ClientRepository clientRepository;

    @Autowired
    protected void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService);
    }

    @PostConstruct
    public void addTestUser() {
        this.savePredefinedUsers(this.predefinedUsers.getUsers(), Lists.newArrayList((Object[])new String[]{"USER"}));
        this.savePredefinedUsers(this.predefinedUsers.getAdmins(), Lists.newArrayList((Object[])new String[]{"USER", ADMIN_ROLE}));
    }

    private void savePredefinedUsers(List<PredefinedUser> users, ArrayList<String> roles) {
        if (users != null) {
            for (PredefinedUser user : users) {
                this.savePredefinedUser(user.getName(), user.getPassword(), roles);
            }
        }
    }

    private void savePredefinedUser(String username, String pass, ArrayList<String> roles) {
        Client user = new Client();
        user.setName(username);
        user.setAccessKey(pass);
        user.setRoles(roles);
        this.clientRepository.save(user);
    }

    @Configuration
    @Order(value=2)
    public static class FormLoginWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            http.csrf().disable();
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/admin/**", "/hal-browser/**"})).hasRole(Security.ADMIN_ROLE).and()).formLogin().loginPage("/login");
        }
    }

    @Configuration
    @Order(value=1)
    public static class ApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).antMatcher("/api/**").authorizeRequests().antMatchers(HttpMethod.POST, new String[]{"/api/abTestConfigurations"})).hasRole(Security.ADMIN_ROLE).antMatchers(HttpMethod.PUT, new String[]{"/api/abTestConfigurations/**"})).hasRole(Security.ADMIN_ROLE).antMatchers(HttpMethod.GET, new String[]{"/api/abTestDecisions/search/deleteByTestName*"})).hasRole(Security.ADMIN_ROLE).antMatchers(HttpMethod.DELETE, new String[]{"/api/abTestConfigurations/**", "/api/abTestDecisions/**"})).hasRole(Security.ADMIN_ROLE).antMatchers(new String[]{"/api/**"})).hasRole("USER").and()).httpBasic().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }
    }
}

