/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.infrastructure.config;

import de.is24.common.abtesting.remote.api.AbTestVariant;
import de.is24.common.abtesting.service.domain.AbTestConfiguration;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.data.rest.webmvc.config.RepositoryRestMvcConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
@EnableGlobalMethodSecurity(securedEnabled=true)
@Import(value={RepositoryRestMvcConfiguration.class})
public class RestMvc
extends RepositoryRestMvcConfiguration {
    @Autowired
    private MessageSource messageSource;

    @Bean
    public Validator validator() {
        LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();
        localValidatorFactoryBean.setValidationMessageSource(this.messageSource);
        return localValidatorFactoryBean;
    }

    protected void configureValidatingRepositoryEventListener(ValidatingRepositoryEventListener validatingListener) {
        validatingListener.addValidator("beforeCreate", this.validator());
    }

    protected void configureRepositoryRestConfiguration(RepositoryRestConfiguration config) {
        config.setBaseUri(URI.create(config.getBaseUri().getPath() + "/api"));
        config.exposeIdsFor(new Class[]{AbTestConfiguration.class});
        config.exposeIdsFor(new Class[]{AbTestVariant.class});
        config.setDefaultPageSize(1000);
    }
}

