/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.infrastructure.config;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"default"})
public class Monitoring {
    @Autowired
    private MetricRegistry metricRegistry;
    private static final long POLL_INTERVAL_IN_SECONDS = 60L;
    @Value(value="${graphite.host:your.graphite.server}")
    private String graphiteHost;
    @Value(value="${graphite.port:42}")
    private Integer graphitePort;
    @Value(value="${graphite.metrics.prefix:your.graphite.metrics.prefix}")
    private String metricPrefix;

    @Bean
    @ConditionalOnExpression(value="${graphite.enabled:false}")
    public GraphiteReporter graphiteReporter() {
        Graphite graphite = new Graphite(new InetSocketAddress(this.graphiteHost, (int)this.graphitePort));
        GraphiteReporter graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith(this.metricPrefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
        graphiteReporter.start(60L, TimeUnit.SECONDS);
        return graphiteReporter;
    }
}

