/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.service.service;

import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import de.is24.common.abtesting.service.domain.AbTestDecision;
import de.is24.common.abtesting.service.repo.AbTestDecisionRepository;
import de.is24.common.abtesting.service.service.LatestDecision;
import de.is24.common.abtesting.service.service.OrphanedTest;
import de.is24.common.abtesting.service.service.TestNameCounter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.mapreduce.GroupBy;
import org.springframework.data.mongodb.core.mapreduce.GroupByResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

@Service
public class AbTestDecisionService {
    private final Logger LOGGER = LoggerFactory.getLogger(AbTestDecisionService.class);
    public static final String DECISIONS_COLLECTION_NAME = "abTestDecision";
    private final AbTestDecisionRepository decisionRepository;
    private final MongoTemplate mongoTemplate;

    @Autowired
    public AbTestDecisionService(AbTestDecisionRepository decisionRepository, MongoTemplate mongoTemplate) {
        this.decisionRepository = decisionRepository;
        this.mongoTemplate = mongoTemplate;
    }

    public Iterable<AbTestDecision> findByDecisionIds(List<String> decisionIds) {
        return this.decisionRepository.findAll(decisionIds);
    }

    public Long deleteByTestName(String testName) {
        return this.decisionRepository.deleteByTestName(testName);
    }

    public List<AbTestDecision> findBySsoId(String userSsoId) {
        return this.decisionRepository.findByUserSsoId(userSsoId);
    }

    public Map<String, DateTime> latestDecisionForConfigurations() {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.project((String[])new String[]{"testName", "created"}), Aggregation.group((String[])new String[]{"testName"}).max("created").as("latestDecision"), Aggregation.project((String[])new String[]{"latestDecision"}).and("testName").previousOperation()});
        AggregationResults latestDecisions = this.mongoTemplate.aggregate(aggregation, DECISIONS_COLLECTION_NAME, LatestDecision.class);
        return this.toMap((AggregationResults<LatestDecision>)latestDecisions);
    }

    private Map<String, DateTime> toMap(AggregationResults<LatestDecision> latestDecisions) {
        HashMap results = Maps.newHashMap();
        for (LatestDecision latestDecision : latestDecisions) {
            results.put(latestDecision.getTestName(), latestDecision.getLatestDecision());
        }
        return results;
    }

    public Map<String, Long> countDecisionsForConfigurations() {
        GroupByResults testNameCounters = this.mongoTemplate.group(DECISIONS_COLLECTION_NAME, GroupBy.key((String[])new String[]{"testName"}).initialDocument((DBObject)new BasicDBObject("count", (Object)0)).reduceFunction("function(doc, prev) { prev.count += 1 }"), TestNameCounter.class);
        return this.toMap((GroupByResults<TestNameCounter>)testNameCounters);
    }

    private Map<String, Long> toMap(GroupByResults<TestNameCounter> testNameCounters) {
        HashMap results = Maps.newHashMap();
        for (TestNameCounter testNameCounter : testNameCounters) {
            results.put(testNameCounter.getTestName(), testNameCounter.getCount());
        }
        return results;
    }

    public List<OrphanedTest> findOrphans(Collection<String> existingConfigurations) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"testName").nin(existingConfigurations)), Aggregation.group((String[])new String[]{"testName"}).max("created").as("latestCreatedDate").count().as("count"), Aggregation.project((String[])new String[]{"latestCreatedDate", "count"}).and("testName").previousOperation()});
        AggregationResults orphanedTests = this.mongoTemplate.aggregate(aggregation, DECISIONS_COLLECTION_NAME, OrphanedTest.class);
        return orphanedTests.getMappedResults();
    }

    public void delete(String userSsoId, String testName) {
        AbTestDecision testDecision = this.decisionRepository.findByTestNameAndUserSsoId(testName, userSsoId);
        if (testDecision != null) {
            this.decisionRepository.delete((Serializable)((Object)testDecision.getId()));
        }
    }

    public void update(String userSsoId, String testName, Integer variantId) {
        AbTestDecision testDecision = this.decisionRepository.findByTestNameAndUserSsoId(testName, userSsoId);
        if (testDecision != null) {
            testDecision.setVariantId(variantId);
            this.decisionRepository.save(testDecision);
        }
    }

    public void saveBatch(Collection<AbTestDecision> testDecisions) {
        for (AbTestDecision testDecision : testDecisions) {
            AbTestDecision existingDecisionForTestAndUser = this.decisionRepository.findByTestNameAndUserSsoId(testDecision.getTestName(), testDecision.getUserSsoId());
            if (existingDecisionForTestAndUser == null) continue;
            this.LOGGER.debug("Deleting existing decision for test {} and SSO-ID {}.", (Object)existingDecisionForTestAndUser.getTestName(), (Object)existingDecisionForTestAndUser.getUserSsoId());
            this.decisionRepository.delete((Serializable)((Object)existingDecisionForTestAndUser.getId()));
        }
        this.decisionRepository.save(testDecisions);
    }
}

