/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.service.service;

import com.google.common.collect.Maps;
import de.is24.common.abtesting.remote.api.AbTestVariant;
import de.is24.common.abtesting.service.domain.AbTestConfiguration;
import de.is24.common.abtesting.service.repo.AbTestConfigurationRepository;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AbTestConfigurationService {
    private AbTestConfigurationRepository repository;

    @Autowired
    public AbTestConfigurationService(AbTestConfigurationRepository repository) {
        this.repository = repository;
    }

    public Iterable<AbTestConfiguration> findAll() {
        return this.repository.findAll();
    }

    public AbTestConfiguration findByName(String name) {
        return this.repository.findByName(name);
    }

    public Iterable<AbTestConfiguration> findByNamePrefix(String prefix) {
        return this.repository.findByNameStartsWith(prefix, (Pageable)new PageRequest(0, 100));
    }

    public AbTestConfiguration save(AbTestConfiguration configuration) {
        return (AbTestConfiguration)this.repository.save(configuration);
    }

    public void delete(String name) {
        this.repository.delete((Serializable)((Object)name));
    }

    public Map<String, AbTestConfiguration> getConfigurationMap() {
        HashMap map = Maps.newHashMap();
        for (AbTestConfiguration abTestConfiguration : this.findAll()) {
            map.put(abTestConfiguration.getName(), abTestConfiguration);
        }
        return map;
    }

    public void removeVariant(AbTestConfiguration configuration, int removeVariant) {
        configuration.getVariants().remove(removeVariant);
        this.normalizeVariantIds(configuration);
    }

    public void addVariant(AbTestConfiguration configuration) {
        configuration.getVariants().add(new AbTestVariant());
        this.normalizeVariantIds(configuration);
    }

    private void normalizeVariantIds(AbTestConfiguration configuration) {
        for (int i = 0; i < configuration.getVariants().size(); ++i) {
            configuration.getVariants().get(i).setId(i);
        }
    }
}

