/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.service.reporting;

import de.is24.common.abtesting.service.domain.AbTestDecision;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DwhOldSchoolAbDecision {
    public static final DateTime NULL_SAFE_TIME = DateTime.parse((String)"02.01.1970", (DateTimeFormatter)DateTimeFormat.forPattern((String)"dd.MM.yyyy"));
    private final String id;
    private final Long hist_id;
    private final String dml_operation;
    private final Long creation_timestamp;
    private final Long modification_timestamp;
    private final String creation_user;
    private final String modification_user;
    private final String testName;
    private final Integer variant;
    private final String ssoId;

    public static DwhOldSchoolAbDecision from(AbTestDecision abTestDecision, Long historyId, String dmlOperation) {
        return new DwhOldSchoolAbDecision(abTestDecision.getId(), historyId, dmlOperation, abTestDecision.getCreated() != null ? abTestDecision.getCreated() : NULL_SAFE_TIME, abTestDecision.getModified() != null ? abTestDecision.getModified() : NULL_SAFE_TIME, abTestDecision.getCreatedBy() != null ? abTestDecision.getCreatedBy() : "anonymous", abTestDecision.getLastModifiedBy(), abTestDecision.getTestName(), abTestDecision.getVariantId(), abTestDecision.getUserSsoId());
    }

    private DwhOldSchoolAbDecision(String id, Long hist_id, String dml_operation, DateTime creationTimestamp, DateTime modificationTimestamp, String creation_user, String modificationUser, String testName, Integer variant, String ssoId) {
        this.id = id;
        this.hist_id = hist_id;
        this.dml_operation = dml_operation;
        this.creation_timestamp = this.toUnixTimeInSeconds(creationTimestamp);
        this.modification_timestamp = this.toUnixTimeInSeconds(modificationTimestamp);
        this.creation_user = creation_user;
        this.modification_user = modificationUser;
        this.testName = testName;
        this.variant = variant;
        this.ssoId = ssoId;
    }

    private long toUnixTimeInSeconds(DateTime creationTimestamp) {
        return creationTimestamp.getMillis() / 1000L;
    }

    public String getId() {
        return this.id;
    }

    public Long getHist_id() {
        return this.hist_id;
    }

    public String getDml_operation() {
        return this.dml_operation;
    }

    public Long getCreation_timestamp() {
        return this.creation_timestamp;
    }

    public Long getModification_timestamp() {
        return this.modification_timestamp;
    }

    public String getCreation_user() {
        return this.creation_user;
    }

    public String getModification_user() {
        return this.modification_user;
    }

    public String getTestName() {
        return this.testName;
    }

    public Integer getVariant() {
        return this.variant;
    }

    public String getSsoId() {
        return this.ssoId;
    }
}

