/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.service.reporting;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import de.is24.common.abtesting.service.domain.AbTestDecision;
import de.is24.common.abtesting.service.reporting.DecisionToHadoopExportCommand;
import de.is24.common.abtesting.service.reporting.DwhOldSchoolAbDecision;
import java.nio.charset.Charset;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.rest.core.event.AbstractRepositoryEventListener;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

@Component
public class DecisionsToHadoopExporter
extends AbstractRepositoryEventListener<AbTestDecision> {
    public static final MediaType JSON_MEDIA_TYPE = new MediaType("application", "json", Charset.forName("UTF-8"));
    public static final HystrixCommand.Setter HADOOP_HYSTRIX_CONFIG = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"HadoopExport"));
    private static final String CREATE_OPERATION = "I";
    private static final String UPDATE_OPERATION = "U";
    private static final String DELETE_OPERATION = "D";
    @Autowired
    private RestOperations hadoopRestOperations;
    @Value(value="${hadoop.enabled:false}")
    public Boolean reportToHadoop;
    @Value(value="${hadoop.rest.url:your.hadoop.server}")
    public String hadoopRestUrl;

    protected void onAfterCreate(AbTestDecision entity) {
        super.onAfterSave((Object)entity);
        this.export(entity, CREATE_OPERATION);
    }

    protected void onAfterSave(AbTestDecision entity) {
        super.onAfterSave((Object)entity);
        this.export(entity, UPDATE_OPERATION);
    }

    protected void onAfterDelete(AbTestDecision entity) {
        super.onBeforeDelete((Object)entity);
        this.export(entity, DELETE_OPERATION);
    }

    private void export(AbTestDecision abTestDecision, String operation) {
        if (this.reportToHadoop.booleanValue()) {
            new DecisionToHadoopExportCommand(HADOOP_HYSTRIX_CONFIG, this.hadoopRestOperations, this.hadoopRestUrl, this.wrapHttpEntity(DwhOldSchoolAbDecision.from(abTestDecision, DateTime.now().getMillis(), operation))).queue();
        }
    }

    private HttpEntity<DwhOldSchoolAbDecision> wrapHttpEntity(DwhOldSchoolAbDecision abTestDecision) {
        return new HttpEntity((Object)abTestDecision, (MultiValueMap)DecisionsToHadoopExporter.getHeaders());
    }

    private static HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(JSON_MEDIA_TYPE);
        return headers;
    }
}

