/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.service.controller;

import com.google.common.collect.Lists;
import de.is24.common.abtesting.service.controller.UploadedDecision;
import de.is24.common.abtesting.service.domain.AbTestDecision;
import de.is24.common.abtesting.service.service.AbTestDecisionService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jsefa.csv.CsvDeserializer;
import org.jsefa.csv.CsvIOFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class DecisionsUploadController {
    public static final CsvIOFactory CSV_IO_FACTORY = CsvIOFactory.createFactory((Class[])new Class[]{UploadedDecision.class});
    @Autowired
    private AbTestDecisionService abTestDecisionService;

    @RequestMapping(value={"/decisionsUpload"}, method={RequestMethod.POST})
    @Secured(value={"ROLE_ADMIN"})
    public String handleDecisionsUpload(@RequestParam(value="decisions") MultipartFile file, RedirectAttributes redirectAttributes) throws IOException {
        byte[] bytes = this.readUploadedFile(file);
        List<AbTestDecision> decisionsFromFile = this.deserializeContent(bytes);
        this.abTestDecisionService.saveBatch(decisionsFromFile);
        redirectAttributes.addAttribute("decisions", (Object)decisionsFromFile.stream().map(AbTestDecision::getId).collect(Collectors.joining(",")));
        redirectAttributes.addAttribute("unused", (Object)0);
        return "redirect:/admin/decisions/decisionsFromUpload";
    }

    private List<AbTestDecision> deserializeContent(byte[] bytes) {
        CsvDeserializer deserializer = CSV_IO_FACTORY.createDeserializer();
        deserializer.open((Reader)new StringReader(new String(bytes)));
        ArrayList decisionsFromFile = Lists.newArrayList();
        while (deserializer.hasNext()) {
            UploadedDecision uploadedDecision = (UploadedDecision)deserializer.next();
            AbTestDecision abTestDecision = new AbTestDecision();
            abTestDecision.setTestName(uploadedDecision.testName);
            abTestDecision.setUserSsoId(uploadedDecision.ssoId);
            abTestDecision.setVariantId(uploadedDecision.variant);
            decisionsFromFile.add(abTestDecision);
        }
        return decisionsFromFile;
    }

    private byte[] readUploadedFile(MultipartFile file) throws IOException {
        String name = file.getName();
        byte[] bytes = file.getBytes();
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(new File(name + "-uploaded")));
        stream.write(bytes);
        stream.close();
        return bytes;
    }
}

