/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.service.controller;

import com.google.common.collect.Lists;
import de.is24.common.abtesting.service.domain.AbTestDecision;
import de.is24.common.abtesting.service.service.AbTestConfigurationService;
import de.is24.common.abtesting.service.service.AbTestDecisionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/admin/decisions"})
public class DecisionController {
    private final AbTestDecisionService decisionService;
    private final AbTestConfigurationService configurationService;

    @Autowired
    public DecisionController(AbTestDecisionService decisionService, AbTestConfigurationService configurationService) {
        this.decisionService = decisionService;
        this.configurationService = configurationService;
    }

    @RequestMapping(value={"/"})
    public String index() {
        return "admin/decision/search";
    }

    @RequestMapping(value={"/decisions"})
    @Secured(value={"ROLE_ADMIN"})
    public String search(String userSsoId, Model model) {
        model.addAttribute("userSsoId", (Object)userSsoId);
        List<AbTestDecision> decisions = this.decisionService.findBySsoId(userSsoId);
        model.addAttribute("decisions", decisions);
        model.addAttribute("configurations", this.configurationService.getConfigurationMap());
        return "admin/decision/decisions";
    }

    @RequestMapping(value={"/decisionsFromUpload"})
    @Secured(value={"ROLE_ADMIN"})
    public String search(String decisions, int unused, Model model) {
        Object[] splitted = decisions.split(",");
        Iterable<AbTestDecision> decisionIds = this.decisionService.findByDecisionIds(Lists.newArrayList((Object[])splitted));
        model.addAttribute("decisions", decisionIds);
        model.addAttribute("configurations", this.configurationService.getConfigurationMap());
        return "admin/decision/decisions";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @Secured(value={"ROLE_ADMIN"})
    public String update(String userSsoId, String testName, Integer variantId, RedirectAttributes redirectAttributes) {
        this.decisionService.update(userSsoId, testName, variantId);
        redirectAttributes.addAttribute("userSsoId", (Object)userSsoId);
        return "redirect:/admin/decisions/decisions";
    }

    @RequestMapping(value={"/delete/{userSsoId}/{testName}"})
    @Secured(value={"ROLE_ADMIN"})
    public String delete(@PathVariable String userSsoId, @PathVariable String testName, RedirectAttributes redirectAttributes) {
        this.decisionService.delete(userSsoId, testName);
        redirectAttributes.addAttribute("userSsoId", (Object)userSsoId);
        return "redirect:/admin/decisions/decisions";
    }
}

