/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.service.controller;

import com.google.common.collect.Lists;
import de.is24.common.abtesting.service.domain.AbTestConfiguration;
import de.is24.common.abtesting.service.service.AbTestConfigurationService;
import de.is24.common.abtesting.service.service.AbTestDecisionService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/admin/configurations"})
public class ConfigurationController {
    private final AbTestConfigurationService abTestConfigurationService;
    private final AbTestDecisionService abTestDecisionService;

    @Autowired
    public ConfigurationController(AbTestConfigurationService service, AbTestDecisionService abTestDecisionService) {
        this.abTestConfigurationService = service;
        this.abTestDecisionService = abTestDecisionService;
    }

    @RequestMapping(value={""})
    @Secured(value={"ROLE_USER"})
    public String index(Model model) {
        Iterable<AbTestConfiguration> allConfigurations = this.abTestConfigurationService.findAll();
        return this.getOverviewModelAndView(model, allConfigurations);
    }

    @RequestMapping(value={"/filter"})
    @Secured(value={"ROLE_USER"})
    public String filterByPrefix(@ModelAttribute(value="prefix") String prefix, Model model) {
        Iterable<AbTestConfiguration> configurations = this.abTestConfigurationService.findByNamePrefix(prefix);
        return this.getOverviewModelAndView(model, configurations);
    }

    @RequestMapping(value={"/edit"})
    @Secured(value={"ROLE_ADMIN"})
    public String edit(@RequestParam(value="name", required=false) String name, Model model) {
        AbTestConfiguration configuration = this.abTestConfigurationService.findByName(name);
        return this.editInternal(configuration, model);
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @Secured(value={"ROLE_ADMIN"})
    public String save(@Valid AbTestConfiguration configuration, BindingResult bindingResult, Model model) {
        if (bindingResult.hasErrors()) {
            return "/admin/configuration/editConfiguration";
        }
        this.abTestConfigurationService.save(configuration);
        return "redirect:/admin/configurations/";
    }

    @RequestMapping(value={"/save"}, params={"addVariant"})
    @Secured(value={"ROLE_ADMIN"})
    public String addVariant(AbTestConfiguration configuration, BindingResult bindingResult, Model model) {
        this.abTestConfigurationService.addVariant(configuration);
        return this.editInternal(configuration, model);
    }

    @RequestMapping(value={"/save"}, params={"removeVariant"})
    @Secured(value={"ROLE_ADMIN"})
    public String removeVariant(AbTestConfiguration configuration, BindingResult bindingResult, int removeVariant, Model model) {
        this.abTestConfigurationService.removeVariant(configuration, removeVariant);
        return this.editInternal(configuration, model);
    }

    @RequestMapping(value={"/delete/{name}"})
    @Secured(value={"ROLE_ADMIN"})
    public String delete(@PathVariable String name, @RequestParam Optional<Boolean> deleteDecisions) {
        this.abTestConfigurationService.delete(name);
        if (deleteDecisions.orElse(false).booleanValue()) {
            this.abTestDecisionService.deleteByTestName(name);
        }
        return "redirect:/admin/configurations/";
    }

    @RequestMapping(value={"/delete-orphan/{name}"})
    @Secured(value={"ROLE_ADMIN"})
    public String deleteOrphan(@PathVariable String name) {
        this.abTestDecisionService.deleteByTestName(name);
        return "redirect:/admin/configurations/";
    }

    private String getOverviewModelAndView(Model model, Iterable<AbTestConfiguration> configurations) {
        model.addAttribute("configurations", configurations);
        model.addAttribute("counters", this.abTestDecisionService.countDecisionsForConfigurations());
        model.addAttribute("lastCreated", this.abTestDecisionService.latestDecisionForConfigurations());
        model.addAttribute("orphans", this.abTestDecisionService.findOrphans(this.toTestNames(configurations)));
        return "admin/configuration/configurations";
    }

    private List<String> toTestNames(Iterable<AbTestConfiguration> allConfigurations) {
        if (allConfigurations == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(allConfigurations).stream().map(AbTestConfiguration::getName).collect(Collectors.toList());
    }

    private String editInternal(AbTestConfiguration configuration, Model model) {
        model.addAttribute("abTestConfiguration", (Object)(configuration != null ? configuration : this.createNewConfiguration()));
        return "admin/configuration/editConfiguration";
    }

    private AbTestConfiguration createNewConfiguration() {
        AbTestConfiguration configuration = new AbTestConfiguration();
        this.abTestConfigurationService.addVariant(configuration);
        return configuration;
    }
}

