/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.remote.api;

import de.is24.common.abtesting.remote.api.AbTestStorageType;
import de.is24.common.abtesting.remote.api.AbTestVariant;
import de.is24.common.abtesting.remote.api.validation.ValidateDateRange;
import de.is24.common.abtesting.remote.api.validation.ValidateVariantIds;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.AutoPopulatingList;

@ValidateDateRange
public class AbTestConfiguration {
    public static final String REL = "abTestConfigurations";
    public static final String DATE_TIME_FORMAT = "dd.MM.YYYY HH:mm";
    @NotEmpty
    @NotNull
    private String name;
    @DateTimeFormat(pattern="dd.MM.YYYY HH:mm")
    @NotNull
    private DateTime from;
    @DateTimeFormat(pattern="dd.MM.YYYY HH:mm")
    @NotNull
    private DateTime to;
    private AbTestStorageType abTestStorageType;
    @NotEmpty
    @Valid
    @ValidateVariantIds
    private List<AbTestVariant> variants = new AutoPopulatingList(AbTestVariant.class);

    public String getName() {
        return this.name;
    }

    public DateTime getFrom() {
        return this.from;
    }

    public DateTime getTo() {
        return this.to;
    }

    public AbTestStorageType getAbTestStorageType() {
        return this.abTestStorageType;
    }

    public List<AbTestVariant> getVariants() {
        return this.variants;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFrom(DateTime from) {
        this.from = from;
    }

    public void setTo(DateTime to) {
        this.to = to;
    }

    public void setAbTestStorageType(AbTestStorageType abTestStorageType) {
        this.abTestStorageType = abTestStorageType;
    }

    public void setVariants(List<AbTestVariant> variants) {
        this.variants = variants;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbTestConfiguration)) {
            return false;
        }
        AbTestConfiguration other = (AbTestConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DateTime this$from = this.getFrom();
        DateTime other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        DateTime this$to = this.getTo();
        DateTime other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        AbTestStorageType this$abTestStorageType = this.getAbTestStorageType();
        AbTestStorageType other$abTestStorageType = other.getAbTestStorageType();
        if (this$abTestStorageType == null ? other$abTestStorageType != null : !((Object)((Object)this$abTestStorageType)).equals((Object)other$abTestStorageType)) {
            return false;
        }
        List<AbTestVariant> this$variants = this.getVariants();
        List<AbTestVariant> other$variants = other.getVariants();
        return !(this$variants == null ? other$variants != null : !((Object)this$variants).equals(other$variants));
    }

    public boolean canEqual(Object other) {
        return other instanceof AbTestConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        DateTime $from = this.getFrom();
        result = result * 59 + ($from == null ? 0 : $from.hashCode());
        DateTime $to = this.getTo();
        result = result * 59 + ($to == null ? 0 : $to.hashCode());
        AbTestStorageType $abTestStorageType = this.getAbTestStorageType();
        result = result * 59 + ($abTestStorageType == null ? 0 : ((Object)((Object)$abTestStorageType)).hashCode());
        List<AbTestVariant> $variants = this.getVariants();
        result = result * 59 + ($variants == null ? 0 : ((Object)$variants).hashCode());
        return result;
    }

    public String toString() {
        return "AbTestConfiguration(name=" + this.getName() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", abTestStorageType=" + (Object)((Object)this.getAbTestStorageType()) + ", variants=" + this.getVariants() + ")";
    }
}

