/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.remote.command;

import de.is24.common.hateoas.HateoasLinkProvider;
import de.is24.common.hateoas.HateoasRequestEntity;
import de.is24.common.hystrix.HystrixConfiguration;
import de.is24.common.togglz.remote.api.RemoteFeatureState;
import de.is24.common.togglz.remote.command.AbstractFeatureStateRemoteCommand;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;

public class GetRemoteFeatureStatesCommand
extends AbstractFeatureStateRemoteCommand<Resources<Resource<RemoteFeatureState>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetRemoteFeatureStatesCommand.class);
    private final String remoteApiUri;

    public GetRemoteFeatureStatesCommand(HystrixConfiguration hysterixConfiguration, RestOperations restOperations, HateoasLinkProvider featureSwitchHateoasLinkProvider, String remoteConfigurationProviderUri) {
        super(hysterixConfiguration.getConfiguration("FeatureStateRemoteGroup"), restOperations, featureSwitchHateoasLinkProvider);
        this.remoteApiUri = remoteConfigurationProviderUri;
    }

    protected Resources<Resource<RemoteFeatureState>> runCommand() throws Exception {
        Link linkToConfigurations = this.getLinkByName(this.remoteApiUri, "featureStates").expand(new Object[0]);
        ResponseEntity responseEntity = this.restOperations.exchange(linkToConfigurations.getHref(), HttpMethod.GET, HateoasRequestEntity.requestEntity(), (ParameterizedTypeReference)new ParameterizedTypeReference<Resources<Resource<RemoteFeatureState>>>(){}, new Object[0]);
        return (Resources)responseEntity.getBody();
    }

    protected Resources<Resource<RemoteFeatureState>> getFallback() {
        LOGGER.warn("No feature states could be retrieved. Using empty remote configuration.", this.getFailedExecutionException());
        return new Resources(Collections.emptyList(), Collections.emptyList());
    }
}

